/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.resolver.ProjectCategoryResolver;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InjectableComponent
public class ProjectCategoryClauseQueryFactory
implements ClauseQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(ProjectCategoryClauseQueryFactory.class);
    private final ProjectCategoryResolver projectCategoryResolver;
    private final JqlOperandResolver jqlOperandResolver;

    public ProjectCategoryClauseQueryFactory(ProjectCategoryResolver projectCategoryResolver, JqlOperandResolver jqlOperandResolver) {
        this.projectCategoryResolver = (ProjectCategoryResolver)Assertions.notNull((String)"projectCategoryResolver", (Object)projectCategoryResolver);
        this.jqlOperandResolver = (JqlOperandResolver)Assertions.notNull((String)"jqlOperandResolver", (Object)jqlOperandResolver);
    }

    public QueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (!this.handlesOperator(operator)) {
            log.debug(String.format("Operator '%s' is not supported.", operator.getDisplayString()));
            return QueryFactoryResult.createFalseResult();
        }
        Set<String> projectIds = this.getProjectIdsFromClause(queryCreationContext, terminalClause);
        return new QueryFactoryResult(this.createQueryForValues(projectIds), this.isNegationOperator(operator));
    }

    private Set<String> getProjectIdsFromClause(QueryCreationContext queryCreationContext, TerminalClause clause) {
        LinkedHashSet<QueryLiteral> rawValues;
        List list = this.jqlOperandResolver.getValues(queryCreationContext, clause.getOperand(), clause);
        LinkedHashSet<Object> linkedHashSet = rawValues = list != null ? new LinkedHashSet<QueryLiteral>(list) : new LinkedHashSet();
        if (this.isNegationOperator(clause.getOperator())) {
            rawValues.add(new QueryLiteral());
        }
        LinkedHashSet<String> idStrings = new LinkedHashSet<String>();
        for (QueryLiteral rawValue : rawValues) {
            Collection<Project> projects = this.projectCategoryResolver.getProjectsForCategory(rawValue);
            for (Project project : projects) {
                idStrings.add(project.getId().toString());
            }
        }
        return idStrings;
    }

    private Query createQueryForValues(Set<String> values) {
        if (values.size() == 1) {
            String value = values.iterator().next();
            return this.getTermQuery(value);
        }
        BooleanQuery.Builder combined = new BooleanQuery.Builder();
        for (String value : values) {
            combined.add((Query)this.getTermQuery(value), BooleanClause.Occur.SHOULD);
        }
        return combined.build();
    }

    private TermQuery getTermQuery(String value) {
        return new TermQuery(new Term(SystemSearchConstants.forProjectCategory().getIndexField(), value));
    }

    private boolean isNegationOperator(Operator operator) {
        return operator == Operator.IS_NOT || operator == Operator.NOT_EQUALS || operator == Operator.NOT_IN;
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains(operator);
    }
}

