/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.List;

public class ComponentResolver
implements NameResolver<ProjectComponent> {
    private final ProjectComponentManager componentManager;

    public ComponentResolver(ProjectComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    public List<String> getIdsFromName(String name) {
        Assertions.notNull((String)"name", (Object)name);
        Collection components = this.componentManager.findByComponentNameCaseInSensitive(name);
        Function function = input -> input.getId().toString();
        return CollectionUtil.transform((Iterable)components, (Function)function);
    }

    public boolean nameExists(String name) {
        Assertions.notNull((String)"name", (Object)name);
        Collection components = this.componentManager.findByComponentNameCaseInSensitive(name);
        return !components.isEmpty();
    }

    public boolean idExists(Long id) {
        Assertions.notNull((String)"id", (Object)id);
        return this.get(id) != null;
    }

    public ProjectComponent get(Long id) {
        try {
            return this.componentManager.find(id);
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    public Collection<ProjectComponent> getAll() {
        return this.componentManager.findAll();
    }
}

