/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.util;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.jql.util.JqlIssueSupport;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.lang.Pair;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class JqlIssueSupportImpl
implements JqlIssueSupport {
    private final IssueManager issueManager;
    private final PermissionManager permissionManager;

    public JqlIssueSupportImpl(IssueManager issueManager, PermissionManager permissionManager) {
        this.issueManager = (IssueManager)Assertions.notNull((String)"issueManager", (Object)issueManager);
        this.permissionManager = (PermissionManager)Assertions.notNull((String)"permissionManager", (Object)permissionManager);
    }

    public Issue getIssue(long id, ApplicationUser user) {
        return this.checkPermission(user, (Issue)this.issueManager.getIssueObject(Long.valueOf(id)), false);
    }

    public Issue getIssue(long id) {
        return this.issueManager.getIssueObject(Long.valueOf(id));
    }

    public List<Issue> getIssues(String issueKey, ApplicationUser user) {
        return this.getIssues(issueKey, user, false);
    }

    public List<Issue> getIssues(String issueKey) {
        return this.getIssues(issueKey, null, true);
    }

    List<Issue> getIssues(String issueKey, ApplicationUser user, boolean skipPermissionCheck) {
        Issue issue = this.getIssue(issueKey, user, skipPermissionCheck);
        return issue != null ? ImmutableList.of((Object)issue) : Collections.emptyList();
    }

    public Issue getIssue(String issueKey, ApplicationUser user) {
        return this.getIssue(issueKey, user, false);
    }

    public Issue getIssue(String issueKey) {
        return this.getIssue(issueKey, null, true);
    }

    private Issue getIssue(String issueKey, ApplicationUser user, boolean skipPermissionCheck) {
        if (StringUtils.isBlank((CharSequence)issueKey)) {
            return null;
        }
        MutableIssue issue = this.issueManager.getIssueByKeyIgnoreCase(issueKey);
        return this.checkPermission(user, (Issue)issue, skipPermissionCheck);
    }

    private Issue checkPermission(ApplicationUser user, Issue issue, boolean skipPermissionCheck) {
        if (issue != null && (skipPermissionCheck || this.permissionManager.hasPermission(10, issue, user))) {
            return issue;
        }
        return null;
    }

    @Nonnull
    public Set<Pair<Long, String>> getProjectIssueTypePairsByKeys(@Nonnull Set<String> issueKeys) {
        return this.issueManager.getProjectIssueTypePairsByKeys(issueKeys);
    }

    @Nonnull
    public Set<Pair<Long, String>> getProjectIssueTypePairsByIds(@Nonnull Set<Long> issueIds) {
        return this.issueManager.getProjectIssueTypePairsByIds(issueIds);
    }

    @Nonnull
    public Set<String> getKeysOfMissingIssues(@Nonnull Set<String> issueKeys) {
        return this.issueManager.getKeysOfMissingIssues(issueKeys);
    }

    @Nonnull
    public Set<Long> getIdsOfMissingIssues(@Nonnull Set<Long> issueIds) {
        return this.issueManager.getIdsOfMissingIssues(issueIds);
    }
}

