/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.issue.index.IndexedChangeHistoryFieldManager;
import com.atlassian.jira.jql.operand.PredicateOperandResolver;
import com.atlassian.jira.jql.operand.registry.JqlFunctionHandlerRegistry;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.jql.validator.HistoryFieldValueValidator;
import com.atlassian.jira.jql.validator.HistoryPredicateValidator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.clause.ChangedClause;

public class ChangedClauseValidator {
    private final IndexedChangeHistoryFieldManager indexedChangeHistoryFieldManager;
    private final HistoryPredicateValidator historyPredicateValidator;

    public ChangedClauseValidator(IndexedChangeHistoryFieldManager indexedChangeHistoryFieldManager, PredicateOperandResolver predicateOperandResolver, JqlDateSupport jqlDateSupport, JiraAuthenticationContext authContext, HistoryFieldValueValidator historyFieldValueValidator, JqlFunctionHandlerRegistry registry, UserManager userManager) {
        this.indexedChangeHistoryFieldManager = indexedChangeHistoryFieldManager;
        this.historyPredicateValidator = new HistoryPredicateValidator(authContext, predicateOperandResolver, jqlDateSupport, historyFieldValueValidator, registry, userManager);
    }

    public MessageSet validate(ApplicationUser searcher, ChangedClause clause) {
        MessageSetImpl messageSet = new MessageSetImpl();
        this.validateField(searcher, clause.getField(), (MessageSet)messageSet);
        if (clause.getPredicate() != null) {
            messageSet.addMessageSet(this.historyPredicateValidator.validate(searcher, clause, clause.getPredicate()));
        }
        return messageSet;
    }

    private void validateField(ApplicationUser searcher, String fieldName, MessageSet messages) {
        if (!this.indexedChangeHistoryFieldManager.getIndexedChangeHistoryFieldNames().contains(fieldName.toLowerCase())) {
            messages.addErrorMessage(this.getI18n(searcher).getText("jira.jql.history.field.not.supported", fieldName));
        }
    }

    I18nHelper getI18n(ApplicationUser user) {
        return new I18nBean(user);
    }
}

