/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.ResolutionIndexInfoResolver;
import com.atlassian.jira.jql.resolver.ResolutionResolver;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.RawValuesExistValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import java.util.Collection;

public class ResolutionValidator
implements ClauseValidator {
    private final RawValuesExistValidator rawValuesExistValidator;
    private final SupportedOperatorsValidator supportedOperatorsValidator;

    public ResolutionValidator(ResolutionResolver resolutionResolver, JqlOperandResolver operandResolver, I18nHelper.BeanFactory beanFactory) {
        this.rawValuesExistValidator = new RawValuesExistValidator(operandResolver, new ResolutionIndexInfoResolver(resolutionResolver), beanFactory);
        this.supportedOperatorsValidator = this.getSupportedOperatorsValidator();
    }

    public MessageSet validate(ApplicationUser searcher, TerminalClause terminalClause) {
        MessageSet messageSet = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        if (!messageSet.hasAnyErrors()) {
            messageSet.addMessageSet(this.rawValuesExistValidator.validate(searcher, terminalClause));
        }
        return messageSet;
    }

    SupportedOperatorsValidator getSupportedOperatorsValidator() {
        return new SupportedOperatorsValidator(new Collection[]{OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, OperatorClasses.RELATIONAL_ONLY_OPERATORS}){

            public MessageSet validate(ApplicationUser searcher, TerminalClause terminalClause) {
                String stringOperand;
                Operand operand = terminalClause.getOperand();
                Operator operator = terminalClause.getOperator();
                if (OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains(operator) && operand instanceof SingleValueOperand && "Unresolved".equalsIgnoreCase(stringOperand = ((SingleValueOperand)operand).getStringValue())) {
                    I18nHelper i18n = this.getI18n(searcher);
                    MessageSetImpl messageSet = new MessageSetImpl();
                    messageSet.addErrorMessage(i18n.getText("jira.jql.clause.does.not.support.operator.operand.combination", operator.getDisplayString(), terminalClause.getName(), stringOperand));
                    return messageSet;
                }
                return super.validate(searcher, terminalClause);
            }
        };
    }
}

