/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.issue.search.optimizers.DeterminedProjectsExtractor;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryCreationContextImpl;
import com.atlassian.jira.jql.validator.AbstractVersionValidator;
import com.atlassian.jira.jql.validator.ChangedClauseValidator;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.OperatorUsageValidator;
import com.atlassian.jira.jql.validator.SavedFilterClauseValidator;
import com.atlassian.jira.jql.validator.ValidatorRegistry;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ListOrderedMessageSetImpl;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import com.atlassian.query.operand.Operand;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ValidatorVisitor
implements ClauseVisitor<MessageSet> {
    private final ValidatorRegistry validatorRegistry;
    private final JqlOperandResolver operandResolver;
    private final OperatorUsageValidator operatorUsageValidator;
    private final ApplicationUser searcher;
    private final Long filterId;
    private final Clause parentClause;

    public ValidatorVisitor(ValidatorRegistry validatorRegistry, JqlOperandResolver operandResolver, OperatorUsageValidator operatorUsageValidator, ApplicationUser searcher, Long filterId, Clause parentClause) {
        this.validatorRegistry = validatorRegistry;
        this.operandResolver = operandResolver;
        this.operatorUsageValidator = operatorUsageValidator;
        this.searcher = searcher;
        this.filterId = filterId;
        this.parentClause = parentClause;
    }

    public MessageSet visit(AndClause andClause) {
        return this.getMessagesFromSubClauses(andClause.getClauses(), (Clause)andClause);
    }

    public MessageSet visit(NotClause notClause) {
        return this.getMessagesFromSubClauses(Collections.singletonList(notClause.getSubClause()), (Clause)notClause);
    }

    public MessageSet visit(OrClause orClause) {
        return this.getMessagesFromSubClauses(orClause.getClauses(), (Clause)orClause);
    }

    public MessageSet visit(TerminalClause clause) {
        Collection<ClauseValidator> validators = this.validatorRegistry.getClauseValidator(this.searcher, clause);
        MessageSet messages = this.validateOperatorAndOperand(clause, validators);
        if (messages.hasAnyErrors()) {
            return messages;
        }
        this.validateClause(clause, validators, messages);
        return messages;
    }

    private MessageSet validateOperatorAndOperand(TerminalClause clause, Collection<ClauseValidator> validators) {
        ListOrderedMessageSetImpl messages = new ListOrderedMessageSetImpl();
        if (!validators.isEmpty()) {
            if (this.validateOperator(clause, (MessageSet)messages)) {
                return messages;
            }
            if (this.validateOperands(clause, (MessageSet)messages)) {
                return messages;
            }
        }
        return messages;
    }

    public MessageSet visit(WasClause clause) {
        Collection<ClauseValidator> wasClauseValidators = this.validatorRegistry.getClauseValidator(this.searcher, clause);
        MessageSet messages = this.validateOperatorAndOperand((TerminalClause)clause, wasClauseValidators);
        if (messages.hasAnyMessages()) {
            return messages;
        }
        this.validateClause((TerminalClause)clause, wasClauseValidators, messages);
        return messages;
    }

    public MessageSet visit(ChangedClause clause) {
        ChangedClauseValidator changedClauseValidator = this.validatorRegistry.getClauseValidator(this.searcher, clause);
        return changedClauseValidator.validate(this.searcher, clause);
    }

    private boolean validateOperator(TerminalClause clause, MessageSet messages) {
        messages.addMessageSet(this.operatorUsageValidator.validate(this.searcher, clause));
        return messages.hasAnyErrors();
    }

    private void validateClause(TerminalClause clause, Collection<ClauseValidator> validators, MessageSet messages) {
        if (!validators.isEmpty()) {
            for (ClauseValidator validator : validators) {
                MessageSet messageSet;
                if (validator instanceof SavedFilterClauseValidator) {
                    messageSet = ((SavedFilterClauseValidator)validator).validate(this.searcher, clause, this.filterId);
                } else if (validator instanceof AbstractVersionValidator) {
                    DeterminedProjectsExtractor determinedProjectsExtractor = new DeterminedProjectsExtractor();
                    Set<String> determinedProjects = determinedProjectsExtractor.extractDeterminedProjectsFromClause(this.parentClause);
                    QueryCreationContextImpl contextWithClause = new QueryCreationContextImpl(this.searcher, false, determinedProjects);
                    messageSet = ((AbstractVersionValidator)validator).validate(clause, (QueryCreationContext)contextWithClause);
                } else {
                    messageSet = validator.validate(this.searcher, clause);
                }
                messages.addMessageSet(messageSet);
            }
        } else {
            I18nHelper i18n = this.getI18n();
            if (this.searcher != null) {
                messages.addErrorMessage(i18n.getText("jira.jql.validation.no.such.field", clause.getName()));
            } else {
                messages.addErrorMessage(i18n.getText("jira.jql.validation.no.such.field.anonymous", clause.getName()));
            }
        }
    }

    I18nHelper getI18n() {
        return new I18nBean(this.searcher);
    }

    private boolean validateOperands(TerminalClause clause, MessageSet messages) {
        Operand operand = clause.getOperand();
        messages.addMessageSet(this.operandResolver.validate(this.searcher, operand, clause));
        return messages.hasAnyErrors();
    }

    private MessageSet getMessagesFromSubClauses(List<Clause> subClauses, Clause parentClause) {
        ListOrderedMessageSetImpl messages = new ListOrderedMessageSetImpl();
        for (Clause subClause : subClauses) {
            MessageSet subMessages = (MessageSet)subClause.accept((ClauseVisitor)this.createNewVisitor(parentClause));
            if (subMessages == null) continue;
            messages.addMessageSet(subMessages);
        }
        return messages;
    }

    private ValidatorVisitor createNewVisitor(Clause parentClause) {
        return new ValidatorVisitor(this.validatorRegistry, this.operandResolver, this.operatorUsageValidator, this.searcher, this.filterId, parentClause);
    }

    public static class ValidatorVisitorFactory {
        private final ValidatorRegistry validatorRegistry;
        private final JqlOperandResolver operandResolver;
        private final OperatorUsageValidator operatorUsageValidator;

        public ValidatorVisitorFactory(ValidatorRegistry validatorRegistry, JqlOperandResolver operandResolver, OperatorUsageValidator operatorUsageValidator) {
            this.validatorRegistry = (ValidatorRegistry)Assertions.notNull((String)"validatorRegistry", (Object)validatorRegistry);
            this.operandResolver = (JqlOperandResolver)Assertions.notNull((String)"operandResolver", (Object)operandResolver);
            this.operatorUsageValidator = (OperatorUsageValidator)Assertions.notNull((String)"operatorUsageValidator", (Object)operatorUsageValidator);
        }

        public ValidatorVisitor createVisitor(ApplicationUser searcher, Long filterId) {
            return new ValidatorVisitor(this.validatorRegistry, this.operandResolver, this.operatorUsageValidator, searcher, filterId, null);
        }

        public ValidatorVisitor createVisitor(ApplicationUser searcher, Long filterId, Clause parentClause) {
            return new ValidatorVisitor(this.validatorRegistry, this.operandResolver, this.operatorUsageValidator, searcher, filterId, parentClause);
        }
    }
}

