/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.changehistory.JqlChangeItemMapping;
import com.atlassian.jira.issue.index.ChangeHistoryFieldConfigurationManager;
import com.atlassian.jira.issue.index.IndexedChangeHistoryFieldManager;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.PredicateOperandResolver;
import com.atlassian.jira.jql.operand.registry.JqlFunctionHandlerRegistry;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.HistoryFieldValueValidator;
import com.atlassian.jira.jql.validator.HistoryPredicateValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.jql.validator.WasValuesExistValidator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import java.util.Collection;

public class WasClauseValidator
implements ClauseValidator {
    private final SupportedOperatorsValidator supportedOperatorsValidator;
    private final JqlOperandResolver operandResolver;
    private final IndexedChangeHistoryFieldManager indexedChangeHistoryFieldManager;
    private final SearchHandlerManager searchHandlerManager;
    private final ChangeHistoryManager changeHistoryManager;
    private final HistoryPredicateValidator historyPredicateValidator;
    private final JqlChangeItemMapping jqlChangeItemMapping;
    private final ChangeHistoryFieldConfigurationManager configurationManager;
    private final HistoryFieldValueValidator historyFieldValueValidator;

    public WasClauseValidator(JqlOperandResolver operandResolver, SearchHandlerManager searchHandlerManager, IndexedChangeHistoryFieldManager indexedChangeHistoryFieldManager, ChangeHistoryManager changeHistoryManager, PredicateOperandResolver predicateOperandResolver, JqlDateSupport jqlDateSupport, JiraAuthenticationContext authContext, JqlChangeItemMapping jqlChangeItemMapping, ChangeHistoryFieldConfigurationManager configurationManager, HistoryFieldValueValidator historyFieldValueValidator, UserManager userManager, JqlFunctionHandlerRegistry registry) {
        this.searchHandlerManager = searchHandlerManager;
        this.operandResolver = operandResolver;
        this.indexedChangeHistoryFieldManager = indexedChangeHistoryFieldManager;
        this.jqlChangeItemMapping = jqlChangeItemMapping;
        this.configurationManager = configurationManager;
        this.historyFieldValueValidator = historyFieldValueValidator;
        this.supportedOperatorsValidator = this.getSupportedOperatorsValidator();
        this.changeHistoryManager = changeHistoryManager;
        this.historyPredicateValidator = new HistoryPredicateValidator(authContext, predicateOperandResolver, jqlDateSupport, historyFieldValueValidator, registry, userManager);
    }

    public MessageSet validate(ApplicationUser searcher, TerminalClause terminalClause) {
        WasClause wasClause = (WasClause)terminalClause;
        WasValuesExistValidator rawValuesExistValidator = this.getRawValuesValidator(terminalClause.getName(), this.operandResolver, searcher);
        MessageSet messageSet = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        messageSet.addMessageSet(rawValuesExistValidator.validate(searcher, wasClause));
        this.validateField(searcher, wasClause.getField(), messageSet);
        if (wasClause.getPredicate() != null) {
            messageSet.addMessageSet(this.historyPredicateValidator.validate(searcher, wasClause, wasClause.getPredicate()));
        }
        return messageSet;
    }

    private void validateField(ApplicationUser searcher, String fieldName, MessageSet messages) {
        if (!this.indexedChangeHistoryFieldManager.getIndexedChangeHistoryFieldNames().contains(fieldName.toLowerCase())) {
            messages.addErrorMessage(this.getI18n(searcher).getText("jira.jql.history.field.not.supported", fieldName));
        }
    }

    SupportedOperatorsValidator getSupportedOperatorsValidator() {
        return new SupportedOperatorsValidator(new Collection[]{OperatorClasses.CHANGE_HISTORY_OPERATORS});
    }

    WasValuesExistValidator getRawValuesValidator(String fieldName, JqlOperandResolver operandResolver, ApplicationUser searcher) {
        return new WasValuesExistValidator(operandResolver, this.searchHandlerManager, this.changeHistoryManager, this.jqlChangeItemMapping, this.configurationManager, this.historyFieldValueValidator);
    }

    I18nHelper getI18n(ApplicationUser user) {
        return new I18nBean(user);
    }
}

