/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.jira.issue.comparator.LocaleSensitiveProjectNameComparator;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.InternalProjectPermissionHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.I18nBean;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class ProjectClauseValuesGenerator
implements ClauseValuesGenerator {
    private final InternalProjectPermissionHelper projectPermissionHelper;

    public ProjectClauseValuesGenerator(InternalProjectPermissionHelper projectPermissionHelper) {
        this.projectPermissionHelper = projectPermissionHelper;
    }

    public ClauseValuesGenerator.Results getPossibleValues(ApplicationUser searcher, String jqlClauseName, String valuePrefix, int maxNumResults) {
        ArrayList<Project> visibleProjects = new ArrayList<Project>(this.projectPermissionHelper.getBrowsableProjects(searcher));
        visibleProjects.sort(new LocaleSensitiveProjectNameComparator(this.getLocale(searcher)));
        ArrayList resultVals = Lists.newArrayListWithCapacity((int)visibleProjects.size());
        for (Project visibleProject : visibleProjects) {
            String lowerCaseKey;
            if (resultVals.size() == maxNumResults) break;
            String lowerCaseProjName = visibleProject.getName().toLowerCase();
            if (!this.valueMatchesProject(valuePrefix, lowerCaseProjName, lowerCaseKey = visibleProject.getKey().toLowerCase())) continue;
            resultVals.add(new ClauseValuesGenerator.Result(visibleProject.getName(), new String[]{visibleProject.getName(), " (" + visibleProject.getKey() + ")"}));
        }
        return new ClauseValuesGenerator.Results((List)resultVals);
    }

    private boolean valueMatchesProject(String valuePrefix, String lowerCaseProjName, String lowerCaseKey) {
        if (StringUtils.isBlank((CharSequence)valuePrefix)) {
            return true;
        }
        if (lowerCaseProjName.startsWith(valuePrefix.toLowerCase())) {
            return true;
        }
        return lowerCaseKey.startsWith(valuePrefix.toLowerCase());
    }

    Locale getLocale(ApplicationUser searcher) {
        return new I18nBean(searcher).getLocale();
    }
}

