/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.logging;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.logging.RollOverLogAppender;
import com.atlassian.jira.startup.JiraHomeStartupCheck;
import java.io.File;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.Queue;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.SimpleMessageFactory;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="JiraHomeAppender", category="Core", elementType="appender", printObject=true)
public class JiraHomeAppender
extends AbstractAppender
implements RollOverLogAppender {
    private static final int QUEUE_MAX = 100;
    private RollingFileAppender fileAppender;
    private final RollingFileAppender.Builder fileAppenderBuilder;
    private JiraHomeStartupCheck startupCheck;
    @GuardedBy(value="this")
    private volatile Queue<LogEvent> events = new LinkedList<LogEvent>();
    private volatile String fileName;
    private final String filePattern;
    private volatile State state = State.WAITING;

    @VisibleForTesting
    JiraHomeAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] propertyArray, RollingFileAppender.Builder rollingFileAppenderBuilder, String fileName, String filePattern) {
        super(name, filter, layout, ignoreExceptions, propertyArray);
        this.fileAppenderBuilder = rollingFileAppenderBuilder;
        this.fileName = fileName;
        this.filePattern = filePattern;
        this.startupCheck = JiraHomeStartupCheck.getInstance();
    }

    @VisibleForTesting
    void setStartupCheck(JiraHomeStartupCheck check) {
        this.startupCheck = check;
    }

    public void stop() {
        this.setStopping();
        this.fileAppender.stop();
        super.stop();
        this.setStopped();
    }

    public void append(LogEvent event) {
        if (this.state == State.READY) {
            this.writeEventToAppender(event);
        } else if (this.state != State.OFF) {
            this.doAppendSync(event);
        }
    }

    @Override
    public String getFile() {
        return this.fileAppender == null ? this.fileName : this.fileAppender.getFileName();
    }

    @Override
    public void rollOver() {
        ((RollingFileManager)this.fileAppender.getManager()).rollover();
    }

    @ClusterSafe(value="Local. This is just appending to the log file.")
    private synchronized void doAppendSync(LogEvent event) {
        if (this.state == State.READY) {
            this.writeEventToAppender(event);
        } else if (this.state == State.WAITING) {
            State configState = this.configureAppender();
            if (configState == State.WAITING) {
                if (this.events.size() < 100) {
                    this.events.add(event);
                } else if (this.events.size() == 100) {
                    this.events.add(this.createDropEvent());
                }
            } else {
                if (configState == State.READY) {
                    for (LogEvent queuedEvent : this.events) {
                        this.writeEventToAppender(queuedEvent);
                    }
                    this.writeEventToAppender(event);
                }
                this.events = null;
                this.fileName = null;
            }
            this.state = configState;
        }
    }

    @VisibleForTesting
    void writeEventToAppender(LogEvent event) {
        this.fileAppender.append(event);
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    private State configureAppender() {
        if (!this.startupCheck.isInitialised()) {
            return State.WAITING;
        }
        if (StringUtils.isBlank((CharSequence)this.fileName)) {
            StatusLogger.getLogger().error("Unable to log to JIRA home: No fileName specified.");
            return State.OFF;
        }
        this.finalizeAppenderBuild();
        return State.READY;
    }

    @VisibleForTesting
    void finalizeAppenderBuild() {
        this.fileAppenderBuilder.withFileName(this.getAppenderFilename(this.fileName));
        this.fileAppenderBuilder.withFilePattern(this.getAppenderFilename(this.filePattern));
        this.fileAppender = this.fileAppenderBuilder.build();
        this.fileAppender.start();
    }

    private String getAppenderFilename(String file) {
        return (String)this.startupCheck.getJiraHomeDirectory().fold(failure -> {
            StatusLogger.getLogger().debug("Unable to log to JIRA home: Unable to find JIRA home. Logging to working directory.");
            return file;
        }, homeDirectory -> {
            File homeLogFile = JiraHomeAppender.getHomeLogFile(homeDirectory, file);
            return homeLogFile == null ? file : homeLogFile.getAbsolutePath();
        });
    }

    static File getHomeLogFile(File home, String fileName) {
        File logDirectory = JiraHomeAppender.normalizeFile(new File(home, "log"));
        if (!logDirectory.exists()) {
            if (!logDirectory.mkdirs()) {
                StatusLogger.getLogger().error("Unable to log to JIRA home: Unable to create directory '" + logDirectory + "'. Logging to working directory.");
                return null;
            }
        } else if (!logDirectory.isDirectory()) {
            StatusLogger.getLogger().error("Unable to log to JIRA home: Log directory '" + logDirectory + "' is not a directory. Logging to working directory.");
            return null;
        }
        return JiraHomeAppender.normalizeFile(new File(logDirectory, fileName));
    }

    private static File normalizeFile(File file) {
        return file.getAbsoluteFile();
    }

    private LogEvent createDropEvent() {
        return new Log4jLogEvent.Builder().setMessage(SimpleMessageFactory.INSTANCE.newMessage("Some log messages dropped during startup. Check application server logs.")).setLevel(Level.ERROR).setLoggerName(this.getClass().getName()).build();
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<JiraHomeAppender> {
        private final RollingFileAppender.Builder rollingFileAppenderBuilder = (RollingFileAppender.Builder)RollingFileAppender.newBuilder().asBuilder();
        @PluginBuilderAttribute
        private String fileName;
        @PluginBuilderAttribute
        @Required
        private String filePattern;
        @PluginBuilderAttribute
        private boolean append = true;
        @PluginBuilderAttribute
        private boolean locking;
        @PluginElement(value="Policy")
        @Required
        private TriggeringPolicy policy;
        @PluginElement(value="Strategy")
        private RolloverStrategy strategy;
        @PluginBuilderAttribute
        private boolean advertise;
        @PluginBuilderAttribute
        private String advertiseUri;
        @PluginBuilderAttribute
        private boolean createOnDemand;
        @PluginBuilderAttribute
        private String filePermissions;
        @PluginBuilderAttribute
        private String fileOwner;
        @PluginBuilderAttribute
        private String fileGroup;

        public B setFileName(String fileName) {
            this.fileName = fileName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setFilePattern(String filePattern) {
            this.filePattern = filePattern;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setAppend(boolean append) {
            this.append = append;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setLocking(boolean locking) {
            this.locking = locking;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setPolicy(TriggeringPolicy policy) {
            this.policy = policy;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setStrategy(RolloverStrategy strategy) {
            this.strategy = strategy;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setAdvertise(boolean advertise) {
            this.advertise = advertise;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setAdvertiseUri(String advertiseUri) {
            this.advertiseUri = advertiseUri;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setCreateOnDemand(boolean createOnDemand) {
            this.createOnDemand = createOnDemand;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setFilePermissions(String filePermissions) {
            this.filePermissions = filePermissions;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setFileOwner(String fileOwner) {
            this.fileOwner = fileOwner;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setFileGroup(String fileGroup) {
            this.fileGroup = fileGroup;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public JiraHomeAppender build() {
            this.rollingFileAppenderBuilder.setName(this.getName());
            this.rollingFileAppenderBuilder.setLayout(this.getLayout());
            this.rollingFileAppenderBuilder.setFilter(this.getFilter());
            this.rollingFileAppenderBuilder.setIgnoreExceptions(this.isIgnoreExceptions());
            this.rollingFileAppenderBuilder.setConfiguration(this.getConfiguration());
            this.rollingFileAppenderBuilder.setPropertyArray(this.getPropertyArray());
            this.rollingFileAppenderBuilder.withAppend(this.append);
            this.rollingFileAppenderBuilder.withLocking(this.locking);
            this.rollingFileAppenderBuilder.withPolicy(this.policy);
            this.rollingFileAppenderBuilder.withStrategy(this.strategy);
            this.rollingFileAppenderBuilder.withAdvertise(this.advertise);
            this.rollingFileAppenderBuilder.withAdvertiseUri(this.advertiseUri);
            this.rollingFileAppenderBuilder.withCreateOnDemand(this.createOnDemand);
            this.rollingFileAppenderBuilder.withFilePermissions(this.filePermissions);
            this.rollingFileAppenderBuilder.withFileOwner(this.fileOwner);
            this.rollingFileAppenderBuilder.withFileGroup(this.fileGroup);
            return new JiraHomeAppender(this.getName(), this.getFilter(), (Layout<? extends Serializable>)this.getLayout(), this.isIgnoreExceptions(), this.getPropertyArray(), this.rollingFileAppenderBuilder, this.fileName, this.filePattern);
        }
    }

    private static enum State {
        WAITING,
        READY,
        OFF;

    }
}

