/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail.attachment;

import com.atlassian.annotations.VisibleForTesting;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImageAttachmentAltAttributeService {
    private static final Pattern IMG_TAG_WITH_ALT_ATTRIBUTE_PATTERN = Pattern.compile("alt *= *['\"]?([^'\"]*)['\"]?");
    private static final int ALT_ATTR_VALUE_GROUP_INDEX_IN_PATTERN = 1;
    private static final Pattern URL_WITH_FILE_NAME_PATTERN = Pattern.compile("^(.*\\/)([^?]*)?(\\?.*)?");
    private static final int FILE_NAME_INDEX_IN_PATTERN = 2;

    public String addDefaultAltAttributeIfNeeded(String imgHtmlTag, String imgSrcUrlBeforeAnyTransformation) {
        String fileName = this.getFileNameFromUrlOrWholeUrl(imgSrcUrlBeforeAnyTransformation);
        Matcher altAttrMatcher = IMG_TAG_WITH_ALT_ATTRIBUTE_PATTERN.matcher(imgHtmlTag);
        StringBuilder result = new StringBuilder(imgHtmlTag);
        if (altAttrMatcher.find()) {
            String altAttributeValue = altAttrMatcher.group(1);
            if (altAttributeValue != null && altAttributeValue.isEmpty()) {
                int emptyAltAttributeStart = altAttrMatcher.start(1);
                result.insert(emptyAltAttributeStart, fileName);
            }
        } else {
            String newAltAttrAtTheEndOfImgTag = String.format(" alt='%s'", fileName);
            result.insert(imgHtmlTag.length() - 1, newAltAttrAtTheEndOfImgTag);
        }
        return result.toString();
    }

    @VisibleForTesting
    protected String getFileNameFromUrlOrWholeUrl(String imgSrcUrlBeforeAnyTransformation) {
        String fileName;
        String imgSrcUrlWithoutProtocol = imgSrcUrlBeforeAnyTransformation.replaceFirst("https://", "").replaceFirst("http://", "");
        Matcher urlMatcher = URL_WITH_FILE_NAME_PATTERN.matcher(imgSrcUrlWithoutProtocol);
        String result = imgSrcUrlBeforeAnyTransformation;
        if (urlMatcher.find() && (fileName = urlMatcher.group(2)) != null && fileName.contains(".")) {
            result = fileName;
        }
        return result;
    }
}

