/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail.util;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarFormatPolicy;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarManagerImpl;
import com.atlassian.jira.avatar.AvatarTranscoder;
import com.atlassian.jira.io.CloseableResourceData;
import com.atlassian.jira.io.MediaConsumer;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentReadException;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.mail.util.ByteArrayDataSource;
import com.atlassian.jira.mail.util.MailAttachment;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.web.ServletContextProvider;
import com.google.common.base.Preconditions;
import io.atlassian.fugue.Option;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.servlet.ServletContext;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailAttachments {
    private static final Logger log = LoggerFactory.getLogger(MailAttachments.class);

    public static MailAttachment newImageAttachment(String imagePath, AvatarTranscoder avatarTranscoder) {
        ServletContext servletContext = ServletContextProvider.getServletContext();
        String mimeType = servletContext.getMimeType(imagePath);
        if (!AvatarManagerImpl.isSvgContentType(mimeType)) {
            return new ImageAttachment(imagePath);
        }
        return new TranscodedImageAttachment(imagePath, avatarTranscoder);
    }

    public static MailAttachment newUrlImageAttachment(String imagePath) {
        return new UrlImageAttachment(imagePath);
    }

    public static MailAttachment newAvatarAttachment(Avatar avatar, String avatarOwnerDescription, AvatarManager avatarManager, Avatar.Size size) {
        return new DefaultAvatarAttachment(avatar, avatarOwnerDescription, avatarManager, size);
    }

    public static MailAttachment newAvatarAttachment(Avatar avatar, String avatarOwnerDescription, AvatarManager avatarManager) {
        return MailAttachments.newAvatarAttachment(avatar, avatarOwnerDescription, avatarManager, Avatar.Size.MEDIUM);
    }

    public static MailAttachment newTranscodedAvatarAttachment(Avatar avatar, String avatarOwnerDescription, AvatarManager avatarManager, Avatar.Size size) {
        return new TranscodedAvatarAttachment(avatar, avatarOwnerDescription, avatarManager, size);
    }

    public static MailAttachment newTranscodedAvatarAttachment(Avatar avatar, String avatarOwnerDescription, AvatarManager avatarManager) {
        return MailAttachments.newTranscodedAvatarAttachment(avatar, avatarOwnerDescription, avatarManager, Avatar.Size.MEDIUM);
    }

    public static MailAttachment newMailAttachmentByStreamingFromAttachmentManager(Attachment attachment, AttachmentManager attachmentManager) {
        return new AttachmentFromAttachmentManager(attachment, attachmentManager);
    }

    public static MailAttachment newMailAttachmentByStreamingFromThumbnailManager(Attachment attachment, ThumbnailManager thumbnailManager) {
        return new ThumbnailFromThumbnailManager(attachment, thumbnailManager);
    }

    private static class ToBodyPartConsumer
    implements Consumer<InputStream> {
        private BodyPart bodyPart;
        private final String contentType;
        private final ToBodyPartContentTypeConsumer contentTypeConsumer;

        private ToBodyPartConsumer(String contentType, ToBodyPartContentTypeConsumer contentTypeConsumer) {
            this.contentType = contentType;
            this.contentTypeConsumer = contentTypeConsumer;
        }

        public void consume(@Nonnull InputStream element) {
            String effectiveContentType = this.contentTypeConsumer.getContentType();
            if (effectiveContentType == null) {
                effectiveContentType = this.contentType;
            }
            try {
                this.bodyPart = new MimeBodyPart();
                this.bodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(element, effectiveContentType)));
            }
            catch (IOException | MessagingException e) {
                log.warn("Cannot read avatar", e);
                this.bodyPart = null;
            }
        }

        private BodyPart getBodyPart() {
            return this.bodyPart;
        }
    }

    private static class ToBodyPartContentTypeConsumer
    implements Consumer<String> {
        private String contentType = null;

        private ToBodyPartContentTypeConsumer() {
        }

        public void consume(@Nonnull String element) {
            this.contentType = element;
        }

        public String getContentType() {
            return this.contentType;
        }
    }

    private static class TranscodedAvatarAttachment
    extends AbstractAvatarAttachment {
        private final AvatarManager avatarManager;
        private final Avatar.Size size;

        private TranscodedAvatarAttachment(@Nullable Avatar avatar, String avatarOwnerDescription, AvatarManager avatarManager, Avatar.Size size) {
            super(avatar, avatarOwnerDescription);
            this.avatarManager = avatarManager;
            this.size = size;
        }

        @Override
        public ToBodyPartConsumer prepareBodyPart() throws IOException {
            AvatarFormatPolicy avatarFormatPolicy = AvatarFormatPolicy.createPngFormatPolicy().withFallingBackToOriginalDataStrategy();
            ToBodyPartContentTypeConsumer bodyPartContentTypeConsumer = new ToBodyPartContentTypeConsumer();
            ToBodyPartConsumer dataAccessor = new ToBodyPartConsumer("image/png", bodyPartContentTypeConsumer);
            MediaConsumer mediaConsumer = new MediaConsumer((Consumer)bodyPartContentTypeConsumer, (Consumer)dataAccessor);
            this.avatarManager.readAvatarData(this.avatar, this.size, avatarFormatPolicy, mediaConsumer);
            return dataAccessor;
        }
    }

    private static class DefaultAvatarAttachment
    extends AbstractAvatarAttachment {
        private final AvatarManager avatarManager;
        private final Avatar.Size size;

        private DefaultAvatarAttachment(@Nullable Avatar avatar, String avatarOwnerDescription, AvatarManager avatarManager, Avatar.Size size) {
            super(avatar, avatarOwnerDescription);
            this.avatarManager = avatarManager;
            this.size = size;
        }

        @Override
        public ToBodyPartConsumer prepareBodyPart() throws IOException {
            AvatarFormatPolicy avatarFormatPolicy = AvatarFormatPolicy.createPngFormatPolicy().withFallingBackToOriginalDataStrategy();
            ToBodyPartContentTypeConsumer bodyPartContentTypeConsumer = new ToBodyPartContentTypeConsumer();
            ToBodyPartConsumer dataAccessor = new ToBodyPartConsumer("image/png", bodyPartContentTypeConsumer);
            MediaConsumer mediaConsumer = new MediaConsumer((Consumer)bodyPartContentTypeConsumer, (Consumer)dataAccessor);
            this.avatarManager.readAvatarData(this.avatar, this.size, avatarFormatPolicy, mediaConsumer);
            return dataAccessor;
        }
    }

    @Nonnull
    private static abstract class AbstractAvatarAttachment
    implements MailAttachment {
        protected final Avatar avatar;
        protected final String avatarOwnerDescription;

        private AbstractAvatarAttachment(@Nullable Avatar avatar, String avatarOwnerDescription) {
            this.avatarOwnerDescription = avatarOwnerDescription;
            this.avatar = avatar;
        }

        public abstract ToBodyPartConsumer prepareBodyPart() throws IOException;

        @Override
        public BodyPart buildBodyPart() {
            try {
                ToBodyPartConsumer dataAccessor = this.prepareBodyPart();
                Option bodyPart = Option.option((Object)dataAccessor.getBodyPart());
                if (bodyPart.isDefined()) {
                    ((BodyPart)bodyPart.get()).setDisposition("inline");
                    return (BodyPart)bodyPart.get();
                }
                return null;
            }
            catch (FileNotFoundException e) {
                log.warn(String.format("Cannot add avatar as Mail attachment for '%s' - file not found", this.avatarOwnerDescription));
                return null;
            }
            catch (IOException e) {
                log.warn(String.format("Cannot add avatar as Mail attachment for '%s'", this.avatarOwnerDescription), (Throwable)e);
                return null;
            }
            catch (MessagingException e) {
                log.warn(String.format("Problem with disposition while adding avatar as Mail attachment for '%s'", this.avatarOwnerDescription), (Throwable)e);
                return null;
            }
        }

        @Override
        public String getUniqueName() {
            UUID uuid = UUID.randomUUID();
            return String.format("avatar-%s", uuid.toString());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AbstractAvatarAttachment)) {
                return false;
            }
            AbstractAvatarAttachment that = (AbstractAvatarAttachment)o;
            return !(this.avatar == null ? that.avatar != null : !this.avatar.equals(that.avatar));
        }

        public int hashCode() {
            return this.avatar == null ? 0 : this.avatar.hashCode();
        }
    }

    private static class UrlImageAttachment
    extends ImageAttachment {
        private UrlImageAttachment(String imagePath) {
            super(imagePath);
        }

        @Override
        protected CloseableResourceData getResourceData() throws MessagingException, IOException {
            try {
                URL url = new URL(this.imagePath);
                URLConnection connection = url.openConnection();
                return new CloseableResourceData(connection.getInputStream(), connection.getContentType());
            }
            catch (MalformedURLException e) {
                throw new MessagingException("Malformed atttachment URL", (Exception)e);
            }
        }
    }

    private static class TranscodedImageAttachment
    extends ImageAttachment {
        private final AvatarTranscoder avatarTranscoder;

        public TranscodedImageAttachment(String imagePath, AvatarTranscoder avatarTranscoder) {
            super(imagePath);
            this.avatarTranscoder = avatarTranscoder;
        }

        /*
         * Exception decompiling
         */
        @Override
        protected CloseableResourceData getResourceData() throws MessagingException, IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static class ImageAttachment
    implements MailAttachment {
        protected final String imagePath;

        private ImageAttachment(String imagePath) {
            Preconditions.checkNotNull((Object)imagePath);
            this.imagePath = imagePath;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public BodyPart buildBodyPart() {
            try (CloseableResourceData resourceData = this.getResourceData();){
                MimeBodyPart bodyPart = new MimeBodyPart();
                bodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(resourceData.getInputStream(), resourceData.getContentType().toString())));
                bodyPart.setDisposition("inline");
                MimeBodyPart mimeBodyPart = bodyPart;
                return mimeBodyPart;
            }
            catch (MessagingException e) {
                log.warn(String.format("Cannot add image as Mail attachment: '%s'", this.imagePath), (Throwable)e);
                return null;
            }
            catch (IOException e) {
                log.warn(String.format("Cannot load resource for: '%s'", this.imagePath), (Throwable)e);
                return null;
            }
        }

        protected CloseableResourceData getResourceData() throws MessagingException, IOException {
            ServletContext servletContext = ServletContextProvider.getServletContext();
            InputStream resourceStream = servletContext.getResourceAsStream(this.imagePath);
            String mimeType = servletContext.getMimeType(this.imagePath);
            return new CloseableResourceData(resourceStream, mimeType);
        }

        @Override
        public String getUniqueName() {
            String name = FilenameUtils.getBaseName((String)this.imagePath);
            UUID uuid = UUID.randomUUID();
            return String.format("static-%s-%s", name, uuid.toString());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImageAttachment that = (ImageAttachment)o;
            return this.imagePath.equals(that.imagePath);
        }

        public int hashCode() {
            return this.imagePath.hashCode();
        }
    }

    private static class ThumbnailFromThumbnailManager
    extends StreamingMailAttachment {
        private final ThumbnailManager thumbnailManager;

        private ThumbnailFromThumbnailManager(Attachment attachment, ThumbnailManager thumbnailManager) {
            super(attachment);
            this.thumbnailManager = thumbnailManager;
        }

        @Override
        DataHandler getDataHandler() throws IOException {
            return (DataHandler)this.thumbnailManager.streamThumbnailContent(this.getAttachment(), inputStream -> new DataHandler((DataSource)new ByteArrayDataSource(inputStream, this.getAttachment().getMimetype())));
        }
    }

    private static class AttachmentFromAttachmentManager
    extends StreamingMailAttachment {
        private final AttachmentManager attachmentManager;

        private AttachmentFromAttachmentManager(Attachment attachment, AttachmentManager attachmentManager) {
            super(attachment);
            this.attachmentManager = attachmentManager;
        }

        @Override
        DataHandler getDataHandler() throws IOException {
            return (DataHandler)this.attachmentManager.streamAttachmentContent(this.getAttachment(), inputStream -> new DataHandler((DataSource)new ByteArrayDataSource(inputStream, this.getAttachment().getMimetype())));
        }
    }

    private static abstract class StreamingMailAttachment
    implements MailAttachment {
        private final Attachment attachment;

        public StreamingMailAttachment(Attachment attachment) {
            this.attachment = attachment;
        }

        abstract DataHandler getDataHandler() throws IOException;

        public Attachment getAttachment() {
            return this.attachment;
        }

        @Override
        public String getUniqueName() {
            return String.format("static-%s", UUID.randomUUID().toString());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StreamingMailAttachment that = (StreamingMailAttachment)o;
            return this.attachment.getId().equals(that.attachment.getId());
        }

        public int hashCode() {
            return this.attachment.getId().hashCode();
        }

        @Override
        public BodyPart buildBodyPart() {
            try {
                MimeBodyPart bodyPart = new MimeBodyPart();
                bodyPart.setDataHandler(this.getDataHandler());
                bodyPart.setDisposition("inline");
                return bodyPart;
            }
            catch (MessagingException e) {
                log.warn(String.format("Cannot add attachment '%s' to email.", this.attachment.getFilename()));
                return null;
            }
            catch (AttachmentReadException | IOException e) {
                log.warn(String.format("Cannot read attachment '%s'", this.attachment.getFilename()));
                return null;
            }
        }
    }
}

