/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mention;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.DCFeatureLicenseChecker;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.MentionIssueCommentEvent;
import com.atlassian.jira.event.issue.MentionIssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.mention.MentionFinder;
import com.atlassian.jira.mention.MentionService;
import com.atlassian.jira.notification.JiraNotificationReason;
import com.atlassian.jira.notification.NotificationFilterManager;
import com.atlassian.jira.notification.NotificationReason;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MentionServiceImpl
implements MentionService {
    private static final MentionService.Mentions EMPTY_RESULT = new MentionService.Mentions(Collections.emptySet(), Collections.emptySet());
    private final MentionFinder finder;
    private final CommentPermissionManager commentPermissionManager;
    private final UserManager userManager;
    private final PermissionManager permissionManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final EventPublisher eventPublisher;
    private final ChangeHistoryManager changeHistoryManager;
    private final NotificationFilterManager notificationFilterManager;
    private final DCFeatureLicenseChecker licenseChecker;

    public MentionServiceImpl(MentionFinder finder, UserManager userManager, PermissionManager permissionManager, GlobalPermissionManager globalPermissionManager, EventPublisher eventPublisher, ChangeHistoryManager changeHistoryManager, CommentPermissionManager commentPermissionManager, NotificationFilterManager notificationFilterManager, DCFeatureLicenseChecker licenseChecker) {
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.globalPermissionManager = globalPermissionManager;
        this.eventPublisher = eventPublisher;
        this.changeHistoryManager = changeHistoryManager;
        this.finder = (MentionFinder)Assertions.notNull((String)"finder", (Object)finder);
        this.commentPermissionManager = commentPermissionManager;
        this.notificationFilterManager = notificationFilterManager;
        this.licenseChecker = licenseChecker;
    }

    public void sendCommentMentions(ApplicationUser remoteUser, Set<NotificationRecipient> currentRecipients, Comment comment, Comment originalComment) {
        this.sendCommentMentions(currentRecipients, remoteUser, comment, originalComment);
    }

    @Nonnull
    public MentionService.MentionResult sendCommentMentions(Set<NotificationRecipient> currentRecipients, ApplicationUser remoteUser, Comment comment, Comment originalComment) {
        if (this.mentionCommentNotValid(remoteUser, comment)) {
            return MentionService.MentionResult.EMPTY;
        }
        Issue issue = comment.getIssue();
        Set<ApplicationUser> mentionedUsers = this.getCommentMentions(remoteUser, issue, comment, originalComment);
        if (mentionedUsers.isEmpty()) {
            return MentionService.MentionResult.EMPTY;
        }
        String mentionText = comment.getBody();
        Set<NotificationRecipient> recipients = this.filterRecipients(mentionedUsers, currentRecipients);
        this.eventPublisher.publish((Object)new MentionIssueCommentEvent(issue, remoteUser, mentionedUsers, recipients, mentionText, "comment", currentRecipients, comment));
        return new MentionService.MentionResult(recipients);
    }

    private boolean mentionCommentNotValid(ApplicationUser remoteUser, Comment comment) {
        return comment == null || !this.isUserAbleToMention(remoteUser);
    }

    public void sendIssueEditMentions(ApplicationUser remoteUser, Set<NotificationRecipient> currentRecipients, @Nonnull Issue issue, Comment comment) {
        this.sendIssueEditMentions(currentRecipients, remoteUser, issue, comment);
    }

    @Nonnull
    public MentionService.MentionResult sendIssueEditMentions(Set<NotificationRecipient> currentRecipients, ApplicationUser remoteUser, @Nonnull Issue issue, Comment comment) {
        Set recipients = this.sendIssueDescriptionMention(currentRecipients, remoteUser, issue, true).getNotificationRecipients();
        if (comment != null) {
            recipients.addAll(this.sendCommentMentions(currentRecipients, remoteUser, comment, null).getNotificationRecipients());
        }
        return new MentionService.MentionResult(recipients);
    }

    public void sendIssueCreateMentions(ApplicationUser remoteUser, Set<NotificationRecipient> currentRecipients, @Nonnull Issue issue) {
        this.sendIssueCreateMentions(currentRecipients, remoteUser, issue);
    }

    @Nonnull
    public MentionService.MentionResult sendIssueCreateMentions(Set<NotificationRecipient> currentRecipients, ApplicationUser remoteUser, @Nonnull Issue issue) {
        return this.sendIssueDescriptionMention(currentRecipients, remoteUser, issue, false);
    }

    private MentionService.MentionResult sendIssueDescriptionMention(Set<NotificationRecipient> currentRecipients, ApplicationUser remoteUser, Issue issue, boolean computePreviousValue) {
        Set<ApplicationUser> mentionedUsers = this.getIssueDescriptionMentions(remoteUser, issue, computePreviousValue);
        if (mentionedUsers.isEmpty()) {
            return MentionService.MentionResult.EMPTY;
        }
        String mentionText = issue.getDescription();
        Set<NotificationRecipient> recipients = this.filterRecipients(mentionedUsers, currentRecipients);
        this.eventPublisher.publish((Object)new MentionIssueEvent(issue, remoteUser, mentionedUsers, recipients, mentionText, "description", currentRecipients));
        return new MentionService.MentionResult(recipients);
    }

    public boolean isUserAbleToMention(ApplicationUser remoteUser) {
        if (Users.isAnonymous((ApplicationUser)remoteUser)) {
            return false;
        }
        boolean skipPermissionCheck = this.licenseChecker.isEnabled(JiraFeatureFlagRegistrar.IGNORE_BROWSE_USERS_PERMISSIONS_IN_USER_PICKERS);
        return skipPermissionCheck || this.globalPermissionManager.hasPermission(GlobalPermissionKey.USER_PICKER, remoteUser);
    }

    @Nonnull
    public MentionService.Mentions getMentionedUsers(@Nonnull IssueEvent issueEvent) {
        Comment originalComment = (Comment)issueEvent.getParams().get("originalcomment");
        return this.getMentionedUsers(issueEvent.getUser(), issueEvent.getEventTypeId(), issueEvent.getIssue(), issueEvent.getComment(), originalComment);
    }

    private MentionService.Mentions getMentionedUsers(@Nullable ApplicationUser remoteUser, Long eventTypeId, @Nonnull Issue issue, @Nullable Comment comment, @Nullable Comment originalComment) {
        if (eventTypeId.equals(EventType.ISSUE_COMMENTED_ID) || eventTypeId.equals(EventType.ISSUE_COMMENT_EDITED_ID)) {
            return new MentionService.Mentions(Collections.emptySet(), this.getCommentMentions(remoteUser, issue, comment, originalComment));
        }
        if (eventTypeId.equals(EventType.ISSUE_CREATED_ID)) {
            return new MentionService.Mentions(this.getIssueDescriptionMentions(remoteUser, issue, false), Collections.emptySet());
        }
        if (eventTypeId.equals(EventType.ISSUE_UPDATED_ID) || eventTypeId.equals(EventType.ISSUE_COMMENT_DELETED_ID)) {
            return new MentionService.Mentions(this.getIssueDescriptionMentions(remoteUser, issue, true), this.getCommentMentions(remoteUser, issue, comment, null));
        }
        if (comment != null) {
            return new MentionService.Mentions(Collections.emptySet(), this.getCommentMentions(remoteUser, issue, comment, null));
        }
        return EMPTY_RESULT;
    }

    @Nonnull
    private Set<ApplicationUser> getIssueDescriptionMentions(@Nullable ApplicationUser remoteUser, @Nonnull Issue issue, boolean computePreviousValue) {
        if (!this.isUserAbleToMention(remoteUser)) {
            return Collections.emptySet();
        }
        String mentionText = issue.getDescription();
        Set<ApplicationUser> mentionedUsers = this.getUsersMentionedInDescription(mentionText, issue);
        boolean containsDescriptionChanges = false;
        if (computePreviousValue) {
            List allChangeHistories = this.changeHistoryManager.getChangeHistories(issue);
            if (!allChangeHistories.isEmpty()) {
                ChangeHistory last = (ChangeHistory)Iterables.getLast((Iterable)allChangeHistories);
                List changeItemBeans = last.getChangeItemBeans();
                for (ChangeItemBean changeItemBean : changeItemBeans) {
                    if (!changeItemBean.getField().equals("description")) continue;
                    Set<ApplicationUser> lastMentionedUsers = this.getUsersMentionedInDescription(changeItemBean.getFromString(), issue);
                    mentionedUsers.removeAll(lastMentionedUsers);
                    containsDescriptionChanges = true;
                    break;
                }
            }
        } else {
            containsDescriptionChanges = true;
        }
        if (!mentionedUsers.isEmpty() && containsDescriptionChanges) {
            return mentionedUsers;
        }
        return Collections.emptySet();
    }

    @Nonnull
    private Set<ApplicationUser> getCommentMentions(@Nullable ApplicationUser remoteUser, @Nonnull Issue issue, @Nullable Comment comment, @Nullable Comment originalComment) {
        if (this.mentionCommentNotValid(remoteUser, comment)) {
            return Collections.emptySet();
        }
        Set<ApplicationUser> mentionedUsers = this.getUsersMentionedInDescription(comment, issue);
        if (originalComment != null) {
            Set<ApplicationUser> originalMentionedUsers = this.getUsersMentionedInDescription(originalComment, issue);
            mentionedUsers.removeAll(originalMentionedUsers);
        }
        return mentionedUsers;
    }

    private Set<ApplicationUser> getUsersMentionedInDescription(String mentionText, @Nonnull Issue issue) {
        return this.getMentionedUsers(mentionText).filter(user -> this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, issue, user)).collect(Collectors.toSet());
    }

    private Set<ApplicationUser> getUsersMentionedInDescription(Comment comment, Issue issue) {
        return this.getMentionedUsers(comment.getBody()).filter(user -> this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, issue, user)).filter(user -> this.commentPermissionManager.hasBrowsePermission(user, comment)).collect(Collectors.toSet());
    }

    private Stream<ApplicationUser> getMentionedUsers(String content) {
        return StreamSupport.stream(this.finder.getMentionedUsernames(content).spliterator(), false).flatMap(this::userByName);
    }

    private Stream<ApplicationUser> userByName(String name) {
        ApplicationUser user = this.userManager.getUserByName(name);
        return user != null ? Stream.of(user) : Stream.of(new ApplicationUser[0]);
    }

    @Nonnull
    private Set<NotificationRecipient> filterRecipients(@Nonnull Set<ApplicationUser> mentionedUsers, Set<NotificationRecipient> previousRecipients) {
        return mentionedUsers.stream().map(NotificationRecipient::new).filter(mentionedUser -> this.userIsNotAlreadyReceivingAnEmail((NotificationRecipient)mentionedUser, previousRecipients)).filter(this::userIsNotFiltered).collect(Collectors.toSet());
    }

    private boolean userIsNotAlreadyReceivingAnEmail(@Nonnull NotificationRecipient recipient, Set<NotificationRecipient> previousRecipients) {
        return previousRecipients == null || !previousRecipients.contains(recipient);
    }

    private boolean userIsNotFiltered(@Nonnull NotificationRecipient recipient) {
        return !this.notificationFilterManager.filtered(recipient, this.notificationFilterManager.makeContextFrom((NotificationReason)JiraNotificationReason.MENTIONED));
    }
}

