/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mention.stats.data;

import com.atlassian.jira.mention.stats.UserSearchServiceStats;
import com.atlassian.jira.mention.stats.data.FindGroupsFrom;
import com.atlassian.jira.mention.stats.data.FindTopUsersCommon;
import com.atlassian.jira.mention.stats.data.FindTopUsersFrom;
import com.atlassian.jira.mention.stats.data.FindTopUsersInternal;
import com.atlassian.jira.mention.stats.data.FindTopUsersWithNameInGroups;
import com.atlassian.jira.mention.stats.data.FindTopUsersWithPermissionInIssue;
import com.atlassian.jira.mention.stats.data.GetUniqueUsers;
import com.atlassian.jira.mention.stats.data.Optimised;
import com.atlassian.jira.permission.PermissionSchemeLogic;
import com.atlassian.jira.util.stats.CountingSerializableStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import java.util.Optional;
import java.util.Set;

public class UserSearchServiceStatsData
implements UserSearchServiceStats {
    final Legacy legacy = new Legacy();
    final Optimised optimised = new Optimised();
    final Common common = new Common();

    public String getStatsName() {
        return "UserSearchServiceStats";
    }

    public Optional<Long> getTotalMeasuredOperationsForStatsOverheadInMillis() {
        return Optional.of(this.legacy.findTopMentionableUsersInIssueLegacyMode.timeInMillis.get().sum() + this.legacy.findTopAssignableUsersLegacyMode.timeInMillis.get().sum() + this.optimised.findTopMentionableUsers.timeInMillis.get().sum() + this.optimised.findTopAssignableUsers.timeInMillis.get().sum() + this.common.getUniqueUsers.timeInMillis.get().sum());
    }

    static MutableLongStats newTimeInMillisAccumulator() {
        return new MutableLongStats(new long[]{5L, 10L, 50L, 100L, 500L, 1000L, 5000L, 10000L, 30000L});
    }

    static MutableLongStats newResultSizeAccumulator() {
        return new MutableLongStats(new long[]{0L, 10L, 100L});
    }

    static CountingSerializableStats newExceptionAccumulator() {
        return new CountingSerializableStats();
    }

    static MutableLongStats newQueryLengthAccumulator() {
        return new MutableLongStats(new long[]{0L, 1L, 2L, 4L, 8L});
    }

    static MutableLongStats newSqlCountAccumulator() {
        return new MutableLongStats(new long[]{0L, 1L, 2L, 3L, 4L, 5L});
    }

    static MutableLongStats newGroupSizeAccumulator() {
        return new MutableLongStats(new long[]{1L, 10L, 100L, 1000L});
    }

    @Override
    public void findTopMentionableUsersInIssueLegacyMode(boolean existingIssue, int queryLength, int topN, int resultSize, long timeInMillis) {
        UserSearchServiceStatsData.setFindTopUsersCommon(this.legacy.findTopMentionableUsersInIssueLegacyMode, existingIssue, topN, queryLength, resultSize, timeInMillis);
    }

    @Override
    public void findTopAssignableUsersLegacyMode(boolean existingIssue, int queryLength, int topN, int resultSize, long timeInMillis) {
        UserSearchServiceStatsData.setFindTopUsersCommon(this.legacy.findTopAssignableUsersLegacyMode, existingIssue, topN, queryLength, resultSize, timeInMillis);
    }

    @Override
    public void findTopMentionableUsers(boolean existingIssue, int queryLength, int topN, int resultSize, long timeInMillis) {
        UserSearchServiceStatsData.setFindTopUsersCommon(this.optimised.findTopMentionableUsers, existingIssue, topN, queryLength, resultSize, timeInMillis);
    }

    @Override
    public void findTopAssignableUsers(boolean existingIssue, int queryLength, int topN, int resultSize, long timeInMillis) {
        UserSearchServiceStatsData.setFindTopUsersCommon(this.optimised.findTopAssignableUsers, existingIssue, topN, queryLength, resultSize, timeInMillis);
    }

    @Override
    public void findTopUsersInternal(Set<String> unsupportedPermissionTypes, int resultSize, long timeInMillis) {
        FindTopUsersInternal findTopUsersInternal = this.optimised.findTopUsersInternal;
        findTopUsersInternal.timeInMillis.accept(timeInMillis);
        findTopUsersInternal.resultSize.accept((long)resultSize);
        findTopUsersInternal.unsupportedPermissionTypes.storeAll(unsupportedPermissionTypes);
    }

    @Override
    public void findInIssueDefinedUsers(int queryLength, int resultSize, long timeInMillis) {
        FindTopUsersInternal.FindInIssueDefinedUsers findInIssueDefinedUsers = this.optimised.findTopUsersInternal.findInIssueDefinedUsers;
        findInIssueDefinedUsers.timeInMillis.accept(timeInMillis);
        findInIssueDefinedUsers.resultSize.accept((long)resultSize);
        findInIssueDefinedUsers.queryLength.accept((long)queryLength);
    }

    @Override
    public void findTopUsersWithPermissionInIssue(int sqlCount, int resultSize, long timeInMillis) {
        FindTopUsersWithPermissionInIssue findTopUsersWithPermissionInIssue = this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssue;
        findTopUsersWithPermissionInIssue.timeInMillis.accept(timeInMillis);
        findTopUsersWithPermissionInIssue.resultSize.accept((long)resultSize);
        findTopUsersWithPermissionInIssue.sqlCount.accept((long)sqlCount);
    }

    @Override
    public void findGroupsFrom(int sqlCount, int resultSize, long timeInMillis) {
        FindGroupsFrom findGroupsFrom = this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssueFromGroups.findGroupsFrom;
        findGroupsFrom.timeInMillis.accept(timeInMillis);
        findGroupsFrom.resultSize.accept((long)resultSize);
        findGroupsFrom.sqlCount.accept((long)sqlCount);
    }

    @Override
    public void isNestedGroupsEnabledForAnyDirectory(int exceptions, int directories, boolean nestedGroupsEnabled, long timeInMillis) {
        FindTopUsersInternal.IsNestedGroupsEnabledForAnyDirectory isNestedGroupsEnabledForAnyDirectory = this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssueFromGroups.isNestedGroupsEnabledForAnyDirectory;
        isNestedGroupsEnabledForAnyDirectory.timeInMillis.accept(timeInMillis);
        isNestedGroupsEnabledForAnyDirectory.exceptions.add((long)exceptions);
        isNestedGroupsEnabledForAnyDirectory.directories.store((Object)directories);
        isNestedGroupsEnabledForAnyDirectory.nestedGroupsEnabled.store((Object)nestedGroupsEnabled);
    }

    @Override
    public void findTopUsersWithPermissionInIssueFromGroups(int resultSize, long timeInMillis) {
        FindTopUsersInternal.FindTopUsersWithPermissionInIssueFromGroups findTopUsersWithPermissionInIssueFromGroups = this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssueFromGroups;
        findTopUsersWithPermissionInIssueFromGroups.timeInMillis.accept(timeInMillis);
        findTopUsersWithPermissionInIssueFromGroups.resultSize.accept((long)resultSize);
    }

    @Override
    public void permissionSchemeLogic(PermissionSchemeLogic permissionSchemeLogic) {
        FindTopUsersInternal.PermissionSchemeLogicStats permissionSchemeLogicStats = this.optimised.findTopUsersInternal.permissionSchemeLogic;
        permissionSchemeLogicStats.nobodyAllowed.incrementConditionally((Object)permissionSchemeLogic.nobodyAllowed());
        permissionSchemeLogicStats.allAllowed.incrementConditionally((Object)permissionSchemeLogic.allAllowed());
        permissionSchemeLogicStats.isGroupAny.incrementConditionally((Object)permissionSchemeLogic.isGroupAny());
        permissionSchemeLogicStats.isApplicationRoleAnyLoggedInUser.incrementConditionally((Object)permissionSchemeLogic.isApplicationRoleAnyLoggedInUser());
        permissionSchemeLogicStats.isIssueUserTypeReporter.incrementConditionally((Object)permissionSchemeLogic.isIssueUserTypeReporter());
        permissionSchemeLogicStats.isIssueUserTypeAssignee.incrementConditionally((Object)permissionSchemeLogic.isIssueUserTypeAssignee());
        permissionSchemeLogicStats.isIssueUserTypeProjectLead.incrementConditionally((Object)permissionSchemeLogic.isIssueUserTypeProjectLead());
        permissionSchemeLogicStats.anyUserType.incrementConditionally((Object)permissionSchemeLogic.anyUserType());
        permissionSchemeLogicStats.isUserTypeUser.incrementConditionally((Object)permissionSchemeLogic.isUserTypeUser());
        permissionSchemeLogicStats.isUserTypeProjectRole.incrementConditionally((Object)permissionSchemeLogic.isUserTypeProjectRole());
        permissionSchemeLogicStats.isUserTypeCustomField.incrementConditionally((Object)permissionSchemeLogic.isUserTypeCustomField());
        permissionSchemeLogicStats.anyGroupType.incrementConditionally((Object)permissionSchemeLogic.anyGroupType());
        permissionSchemeLogicStats.isGroupTypeGroup.incrementConditionally((Object)permissionSchemeLogic.isGroupTypeGroup());
        permissionSchemeLogicStats.isGroupTypeProjectRole.incrementConditionally((Object)permissionSchemeLogic.isGroupTypeProjectRole());
        permissionSchemeLogicStats.isGroupTypeCustomField.incrementConditionally((Object)permissionSchemeLogic.isGroupTypeCustomField());
        permissionSchemeLogicStats.isGroupTypeApplicationRole.incrementConditionally((Object)permissionSchemeLogic.isGroupTypeApplicationRole());
    }

    @Override
    public void getUniqueUsers(int activeDirectories, int inactiveDirectories, int inputSize, int resultSize, int removedInactiveDirectoryUsers, int removedUnknownDirectoryUsers, int removedDuplicateUsers, long timeInMillis) {
        GetUniqueUsers getUniqueUsers = this.common.getUniqueUsers;
        getUniqueUsers.activeDirectories.store((Object)activeDirectories);
        getUniqueUsers.inactiveDirectories.store((Object)inactiveDirectories);
        getUniqueUsers.inputSize.accept((long)inputSize);
        getUniqueUsers.resultSize.accept((long)resultSize);
        getUniqueUsers.removedInactiveDirectoryUsers.accept((long)removedInactiveDirectoryUsers);
        getUniqueUsers.removedUnknownDirectoryUsers.accept((long)removedUnknownDirectoryUsers);
        getUniqueUsers.removedDuplicateUsers.accept((long)removedDuplicateUsers);
        getUniqueUsers.timeInMillis.accept(timeInMillis);
    }

    @Override
    public void queryDslJiraCrowdDAOSettings(int maxTop, int batchSize, int numberOfBatches, int maxGroupNestedLevel) {
        FindTopUsersWithNameInGroups.QueryDslJiraCrowdDAOSettings queryDslJiraCrowdDAOSettings = this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssueFromGroups.findTopUsersWithNameInGroups.queryDslJiraCrowdDAOSettings;
        queryDslJiraCrowdDAOSettings.maxTop.store((Object)maxTop);
        queryDslJiraCrowdDAOSettings.batchSize.store((Object)batchSize);
        queryDslJiraCrowdDAOSettings.numberOfBatches.store((Object)numberOfBatches);
        queryDslJiraCrowdDAOSettings.maxGroupNestedLevel.store((Object)maxGroupNestedLevel);
    }

    @Override
    public void findTopUsersWithNameInGroups(int groupSize, int resultSize, long timeInMillis) {
        FindTopUsersWithNameInGroups findTopUsersWithNameInGroups = this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssueFromGroups.findTopUsersWithNameInGroups;
        findTopUsersWithNameInGroups.timeInMillis.accept(timeInMillis);
        findTopUsersWithNameInGroups.resultSize.accept((long)resultSize);
        findTopUsersWithNameInGroups.groupSize.accept((long)groupSize);
    }

    @Override
    public void findTopUsersWithNameInGroupsException(int groupSize, long timeInMillis) {
        FindTopUsersWithNameInGroups findTopUsersWithNameInGroups = this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssueFromGroups.findTopUsersWithNameInGroups;
        findTopUsersWithNameInGroups.timeInMillis.accept(timeInMillis);
        findTopUsersWithNameInGroups.exception.increment();
        findTopUsersWithNameInGroups.groupSize.accept((long)groupSize);
    }

    @Override
    public void findTopUsers(int resultSize, long timeInMillis) {
        FindTopUsersInternal.FindTopUsers findTopUsers = this.optimised.findTopUsersInternal.findTopUsers;
        findTopUsers.timeInMillis.accept(timeInMillis);
        findTopUsers.resultSize.accept((long)resultSize);
    }

    @Override
    public void findTopUsersException(long timeInMillis) {
        FindTopUsersInternal.FindTopUsers findTopUsers = this.optimised.findTopUsersInternal.findTopUsers;
        findTopUsers.timeInMillis.accept(timeInMillis);
        findTopUsers.exception.increment();
    }

    @Override
    public void findNestedGroupsOf(int groupSize, int resultSize, long timeInMillis) {
        FindTopUsersInternal.FindNestedGroupsOf findNestedGroupsOf = this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssueFromGroups.findNestedGroupsOf;
        findNestedGroupsOf.timeInMillis.accept(timeInMillis);
        findNestedGroupsOf.resultSize.accept((long)resultSize);
        findNestedGroupsOf.groupSize.accept((long)groupSize);
    }

    @Override
    public void findNestedGroupsOfException(int groupSize, long timeInMillis) {
        FindTopUsersInternal.FindNestedGroupsOf findNestedGroupsOf = this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssueFromGroups.findNestedGroupsOf;
        findNestedGroupsOf.timeInMillis.accept(timeInMillis);
        findNestedGroupsOf.exception.increment();
        findNestedGroupsOf.groupSize.accept((long)groupSize);
    }

    @Override
    public void getPermissionSchemeIdFor(long timeInMillis) {
        this.optimised.findTopUsersInternal.getPermissionSchemeIdFor.timeInMillis.accept(timeInMillis);
    }

    @Override
    public void getPermissionSchemeIdForException(long timeInMillis) {
        FindTopUsersInternal.GetPermissionSchemeId getPermissionSchemeIdFor = this.optimised.findTopUsersInternal.getPermissionSchemeIdFor;
        getPermissionSchemeIdFor.timeInMillis.accept(timeInMillis);
        getPermissionSchemeIdFor.exception.increment();
    }

    @Override
    public void getSchemePermissions(int resultSize, long timeInMillis) {
        FindTopUsersInternal.GetSchemePermissions getSchemePermissions = this.optimised.findTopUsersInternal.getSchemePermissions;
        getSchemePermissions.timeInMillis.accept(timeInMillis);
        getSchemePermissions.resultSize.accept((long)resultSize);
    }

    @Override
    public void getSchemePermissionsException(long timeInMillis) {
        FindTopUsersInternal.GetSchemePermissions getSchemePermissions = this.optimised.findTopUsersInternal.getSchemePermissions;
        getSchemePermissions.timeInMillis.accept(timeInMillis);
        getSchemePermissions.exception.increment();
    }

    @Override
    public void findGroupsFromTypeGroup(int resultSize, long timeInMillis) {
        UserSearchServiceStatsData.setFindGroupsFrom(this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssueFromGroups.findGroupsFrom.findGroupsFromTypeGroup, resultSize, timeInMillis);
    }

    @Override
    public void findGroupsFromTypeGroupException(long timeInMillis) {
        UserSearchServiceStatsData.setFindGroupsFromException(this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssueFromGroups.findGroupsFrom.findGroupsFromTypeGroup, timeInMillis);
    }

    @Override
    public void findGroupsFromTypeProjectRoleGroup(int resultSize, long timeInMillis) {
        UserSearchServiceStatsData.setFindGroupsFrom(this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssueFromGroups.findGroupsFrom.findGroupsFromTypeProjectRoleGroup, resultSize, timeInMillis);
    }

    @Override
    public void findGroupsFromTypeProjectRoleGroupException(long timeInMillis) {
        UserSearchServiceStatsData.setFindGroupsFromException(this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssueFromGroups.findGroupsFrom.findGroupsFromTypeProjectRoleGroup, timeInMillis);
    }

    @Override
    public void findGroupsFromGroupCF(int resultSize, long timeInMillis) {
        UserSearchServiceStatsData.setFindGroupsFrom(this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssueFromGroups.findGroupsFrom.findGroupsFromGroupCF, resultSize, timeInMillis);
    }

    @Override
    public void findGroupsFromGroupCFException(long timeInMillis) {
        UserSearchServiceStatsData.setFindGroupsFromException(this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssueFromGroups.findGroupsFrom.findGroupsFromGroupCF, timeInMillis);
    }

    @Override
    public void findGroupsFromSelectCF(int resultSize, long timeInMillis) {
        UserSearchServiceStatsData.setFindGroupsFrom(this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssueFromGroups.findGroupsFrom.findGroupsFromSelectCF, resultSize, timeInMillis);
    }

    @Override
    public void findGroupsFromSelectCFException(long timeInMillis) {
        UserSearchServiceStatsData.setFindGroupsFromException(this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssueFromGroups.findGroupsFrom.findGroupsFromSelectCF, timeInMillis);
    }

    @Override
    public void findGroupsFromApplicationRole(int resultSize, long timeInMillis) {
        UserSearchServiceStatsData.setFindGroupsFrom(this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssueFromGroups.findGroupsFrom.findGroupsFromApplicationRole, resultSize, timeInMillis);
    }

    @Override
    public void findGroupsFromApplicationRoleException(long timeInMillis) {
        UserSearchServiceStatsData.setFindGroupsFromException(this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssueFromGroups.findGroupsFrom.findGroupsFromApplicationRole, timeInMillis);
    }

    @Override
    public void findTopUsersFromTypeUser(int resultSize, long timeInMillis) {
        UserSearchServiceStatsData.setFindTopUsersFrom(this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssue.findTopUsersFromTypeUser, resultSize, timeInMillis);
    }

    @Override
    public void findTopUsersFromTypeUserException(long timeInMillis) {
        UserSearchServiceStatsData.setFindTopUsersFromException(this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssue.findTopUsersFromTypeUser, timeInMillis);
    }

    @Override
    public void findTopUsersFromUserCF(int resultSize, long timeInMillis) {
        UserSearchServiceStatsData.setFindTopUsersFrom(this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssue.findTopUsersFromUserCF, resultSize, timeInMillis);
    }

    @Override
    public void findTopUsersFromUserCFException(long timeInMillis) {
        UserSearchServiceStatsData.setFindTopUsersFromException(this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssue.findTopUsersFromUserCF, timeInMillis);
    }

    @Override
    public void findTopUsersFromTypeProjectRoleUsers(int resultSize, long timeInMillis) {
        UserSearchServiceStatsData.setFindTopUsersFrom(this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssue.findTopUsersFromTypeProjectRoleUsers, resultSize, timeInMillis);
    }

    @Override
    public void findTopUsersFromTypeProjectRoleUsersException(long timeInMillis) {
        UserSearchServiceStatsData.setFindTopUsersFromException(this.optimised.findTopUsersInternal.findTopUsersWithPermissionInIssue.findTopUsersFromTypeProjectRoleUsers, timeInMillis);
    }

    private static void setFindGroupsFrom(FindGroupsFrom.FindGroupsFromType findGroupsFromType, int resultSize, long timeInMillis) {
        findGroupsFromType.timeInMillis.accept(timeInMillis);
        findGroupsFromType.resultSize.accept((long)resultSize);
    }

    private static void setFindGroupsFromException(FindGroupsFrom.FindGroupsFromType findGroupsFromType, long timeInMillis) {
        findGroupsFromType.timeInMillis.accept(timeInMillis);
        findGroupsFromType.exception.increment();
    }

    private static void setFindTopUsersFrom(FindTopUsersFrom findTopUsersFrom, int resultSize, long timeInMillis) {
        findTopUsersFrom.timeInMillis.accept(timeInMillis);
        findTopUsersFrom.resultSize.accept((long)resultSize);
    }

    private static void setFindTopUsersFromException(FindTopUsersFrom findTopUsersFrom, long timeInMillis) {
        findTopUsersFrom.timeInMillis.accept(timeInMillis);
        findTopUsersFrom.exception.increment();
    }

    private static void setFindTopUsersCommon(FindTopUsersCommon findTopUsersCommon, boolean existingIssue, int topN, int queryLength, int resultSize, long timeInMillis) {
        findTopUsersCommon.timeInMillis.accept(timeInMillis);
        findTopUsersCommon.resultSize.accept((long)resultSize);
        findTopUsersCommon.queryLength.accept((long)queryLength);
        (existingIssue ? findTopUsersCommon.existingIssue : findTopUsersCommon.newIssue).increment();
        findTopUsersCommon.topN.accept((long)topN);
    }

    static class Common {
        final GetUniqueUsers getUniqueUsers = new GetUniqueUsers();

        Common() {
        }
    }

    static class Legacy {
        final FindTopUsersCommon findTopMentionableUsersInIssueLegacyMode = new FindTopUsersCommon();
        final FindTopUsersCommon findTopAssignableUsersLegacyMode = new FindTopUsersCommon();

        Legacy() {
        }
    }
}

