/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.message;

import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.message.MessageUtil;
import com.atlassian.jira.message.MessageUtilImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.BaseUrl;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import java.util.Locale;

public class MessageUtilFactory
implements MessageUtil.Factory {
    private final I18nHelper.BeanFactory i1BeanFactory;
    private final HelpUrls helpUrls;
    private final ExternalLinkUtil externalLinkUtil;
    private final JiraAuthenticationContext context;
    private final BaseUrl baseUrl;

    public MessageUtilFactory(JiraAuthenticationContext context, I18nHelper.BeanFactory i1BeanFactory, ExternalLinkUtil externalLinkUtil, HelpUrls helpUrls, BaseUrl baseUrl) {
        this.context = (JiraAuthenticationContext)Assertions.notNull((String)"context", (Object)context);
        this.i1BeanFactory = (I18nHelper.BeanFactory)Assertions.notNull((String)"i1BeanFactory", (Object)i1BeanFactory);
        this.externalLinkUtil = (ExternalLinkUtil)Assertions.notNull((String)"externalLinkUtil", (Object)externalLinkUtil);
        this.helpUrls = (HelpUrls)Assertions.notNull((String)"helpUrls", (Object)helpUrls);
        this.baseUrl = (BaseUrl)Assertions.notNull((String)"baseUrl", (Object)baseUrl);
    }

    @Override
    public MessageUtil getNewInstance() {
        return new MessageUtilImpl(this.context.getI18nHelper(), this.helpUrls, this.externalLinkUtil, this.baseUrl);
    }

    @Override
    public MessageUtil getNewInstance(ApplicationUser user) {
        return new MessageUtilImpl(this.i1BeanFactory.getInstance(user), this.helpUrls, this.externalLinkUtil, this.baseUrl);
    }

    @Override
    public MessageUtil getNewInstance(Locale locale) {
        return new MessageUtilImpl(this.i1BeanFactory.getInstance(locale), this.helpUrls, this.externalLinkUtil, this.baseUrl);
    }
}

