/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.notification.IssueEventNotificationFilterContext;
import com.atlassian.jira.notification.NotificationFilter;
import com.atlassian.jira.notification.NotificationFilterContext;
import com.atlassian.jira.notification.NotificationFilterManager;
import com.atlassian.jira.notification.NotificationFilterModuleDescriptor;
import com.atlassian.jira.notification.NotificationReason;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.type.NotificationType;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationFilterManagerImpl
implements NotificationFilterManager {
    private static final Logger log = LoggerFactory.getLogger(NotificationFilterManagerImpl.class);
    private final PluginModuleTracker<NotificationFilter, NotificationFilterModuleDescriptor> pluginModuleTracker;

    public NotificationFilterManagerImpl(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        this.pluginModuleTracker = this.createTracker(pluginAccessor, pluginEventManager);
    }

    @VisibleForTesting
    protected PluginModuleTracker<NotificationFilter, NotificationFilterModuleDescriptor> createTracker(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        return DefaultPluginModuleTracker.create((PluginAccessor)pluginAccessor, (PluginEventManager)pluginEventManager, NotificationFilterModuleDescriptor.class);
    }

    @Override
    public Iterable<NotificationRecipient> recomputeRecipients(Iterable<NotificationRecipient> recipients, final NotificationFilterContext context) {
        final Iterable<NotificationFilter> notificationFilters = this.enabledNotificationFilters();
        Iterable added = Iterables.concat(recipients, this.addRecipients(notificationFilters, context));
        return Iterables.filter((Iterable)added, (Predicate)new Predicate<NotificationRecipient>(){

            public boolean apply(@Nullable NotificationRecipient input) {
                return !NotificationFilterManagerImpl.this.removeRecipient(notificationFilters, input, context);
            }
        });
    }

    @Override
    public boolean filtered(NotificationRecipient recipient, NotificationFilterContext context) {
        return this.removeRecipient(this.enabledNotificationFilters(), recipient, context);
    }

    @Override
    public NotificationFilterContext makeContextFrom(NotificationReason reason) {
        return new NotificationFilterContext(reason);
    }

    @Override
    public NotificationFilterContext makeContextFrom(NotificationReason reason, Issue issue) {
        return new NotificationFilterContext(reason, issue);
    }

    @Override
    public NotificationFilterContext makeContextFrom(NotificationReason reason, IssueEvent issueEvent) {
        return new IssueEventNotificationFilterContext(reason, issueEvent, null);
    }

    @Override
    public NotificationFilterContext makeContextFrom(NotificationFilterContext copy, NotificationType notificationType) {
        if (copy instanceof IssueEventNotificationFilterContext) {
            return new IssueEventNotificationFilterContext((IssueEventNotificationFilterContext)copy, notificationType);
        }
        return new NotificationFilterContext(copy);
    }

    private Iterable<NotificationRecipient> addRecipients(Iterable<NotificationFilter> notificationFilters, NotificationFilterContext context) {
        HashSet allRecipients = Sets.newHashSet();
        for (NotificationFilter notificationFilter : notificationFilters) {
            try {
                Iterable recipients = notificationFilter.addRecipient(context, (Iterable)ImmutableSet.copyOf((Collection)allRecipients));
                if (recipients == null || Iterables.isEmpty((Iterable)recipients)) continue;
                Iterables.addAll((Collection)allRecipients, (Iterable)recipients);
                if (!log.isDebugEnabled()) continue;
                log.debug(String.format("Added extra recipients via plugin '%s'", notificationFilter.getClass().getName()));
            }
            catch (RuntimeException e) {
                log.error(String.format("Ignoring notification filter of type '%s' because of '%s'", notificationFilter.getClass().getName(), e.getMessage()));
            }
        }
        return allRecipients;
    }

    private boolean removeRecipient(Iterable<NotificationFilter> notificationFilters, NotificationRecipient recipient, NotificationFilterContext context) {
        for (NotificationFilter notificationFilter : notificationFilters) {
            try {
                if (!notificationFilter.removeRecipient(recipient, context)) continue;
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Removed '%s' as a notification recipient via plugin '%s'", recipient, notificationFilter.getClass().getName()));
                }
                return true;
            }
            catch (RuntimeException e) {
                log.error(String.format("Ignoring notification filter of type '%s' because of '%s'", notificationFilter.getClass().getName(), e.getMessage()));
            }
        }
        return false;
    }

    @VisibleForTesting
    protected Iterable<NotificationFilter> enabledNotificationFilters() {
        return Iterables.filter((Iterable)this.pluginModuleTracker.getModules(), (Predicate)new Predicate<NotificationFilter>(){

            public boolean apply(@Nullable NotificationFilter input) {
                return input != null;
            }
        });
    }
}

