/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.NotificationType;
import com.atlassian.jira.notification.NotificationTypeManager;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NotificationRecipientsSource {
    private static final Logger log = LoggerFactory.getLogger(NotificationRecipientsSource.class);
    private final NotificationTypeManager notificationTypeManager;
    private final UserPreferencesManager userPreferencesManager;
    private final ApplicationRoleManager applicationRoleManager;
    private final Function<ApplicationUser, NotificationRecipient> recipientFactory;
    private final FeatureManager featureManager;

    NotificationRecipientsSource(NotificationTypeManager notificationTypeManager, UserPreferencesManager userPreferencesManager, ApplicationRoleManager applicationRoleManager, FeatureManager featureManager) {
        this(notificationTypeManager, userPreferencesManager, applicationRoleManager, NotificationRecipient::new, featureManager);
    }

    @VisibleForTesting
    NotificationRecipientsSource(NotificationTypeManager notificationTypeManager, UserPreferencesManager userPreferencesManager, ApplicationRoleManager applicationRoleManager, Function<ApplicationUser, NotificationRecipient> recipientFactory, FeatureManager featureManager) {
        this.notificationTypeManager = notificationTypeManager;
        this.userPreferencesManager = userPreferencesManager;
        this.applicationRoleManager = applicationRoleManager;
        this.recipientFactory = recipientFactory;
        this.featureManager = featureManager;
    }

    Set<NotificationRecipient> getRecipients(IssueEvent event, Collection<SchemeEntity> schemes) {
        Set recipients = schemes.stream().flatMap(scheme -> this.getActiveRecipients(event, (SchemeEntity)scheme)).collect(Collectors.toCollection(LinkedHashSet::new));
        ApplicationUser issuer = event.getUser();
        if (issuer != null && !this.includeEventIssuer(issuer)) {
            recipients.remove(this.recipientFactory.apply(issuer));
            if (log.isDebugEnabled()) {
                log.debug("Removed user {} with email address {} from notification because they are the modifier and do not wish to be notified.", (Object)issuer.getDisplayName(), (Object)issuer.getEmailAddress());
            }
        }
        return Collections.unmodifiableSet(recipients);
    }

    private Stream<NotificationRecipient> getActiveRecipients(IssueEvent event, SchemeEntity scheme) {
        NotificationType notificationType = this.notificationTypeManager.getNotificationType(scheme.getType());
        return notificationType.getRecipients(event, scheme.getParameter()).stream().filter(this::isActive);
    }

    private boolean isActive(NotificationRecipient recipient) {
        ApplicationUser user = recipient.getUser();
        if (user == null) {
            return true;
        }
        if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.NOTIFY_USERS_WITHOUT_APPLICATION_ACCESS)) {
            return user.isActive();
        }
        return user.isActive() && this.applicationRoleManager.hasAnyRole(user);
    }

    private boolean includeEventIssuer(ApplicationUser emitter) {
        ExtendedPreferences userPreference = this.userPreferencesManager.getExtendedPreferences(emitter);
        return userPreference.getBoolean("user.notify.own.changes");
    }
}

