/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification.type;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.type.AbstractNotificationType;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.opensymphony.util.TextUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleUser
extends AbstractNotificationType {
    private static final Logger log = LoggerFactory.getLogger(SingleUser.class);
    public static final String DESC = "Single_User";
    private JiraAuthenticationContext jiraAuthenticationContext;

    public SingleUser(JiraAuthenticationContext jiraAuthenticationContext) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public List<NotificationRecipient> getRecipients(IssueEvent event, String userKey) {
        ApplicationUser u = this.getUserManager().getUserByKey(userKey);
        if (u != null) {
            return Collections.singletonList(new NotificationRecipient(u));
        }
        return Collections.emptyList();
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.notification.types.single.user");
    }

    @Override
    public String getType() {
        return "user";
    }

    @Override
    public boolean doValidation(String key, Map parameters) {
        Object value = parameters.get(key);
        if (value instanceof String) {
            String displayValue = (String)value;
            return TextUtils.stringSet((String)displayValue) && this.getArgumentValue(displayValue) != null;
        }
        return false;
    }

    @Override
    public String getArgumentDisplay(String argument) {
        ApplicationUser user = this.getUserManager().getUserByKey(argument);
        return user != null ? user.getUsername() : argument;
    }

    @Override
    public String getArgumentValue(String displayValue) {
        ApplicationUser user = this.getUserManager().getUserByName(displayValue);
        return user != null ? user.getKey() : null;
    }

    UserManager getUserManager() {
        return ComponentAccessor.getUserManager();
    }
}

