/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz;

import com.atlassian.jira.ofbiz.OfBizLogHelper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.ofbiz.core.entity.jdbc.interceptors.connection.ConnectionPoolState;
import org.ofbiz.core.entity.jdbc.interceptors.connection.SQLConnectionInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoggingSQLInterceptor
implements SQLConnectionInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LoggingSQLInterceptor.class);
    private long startTime;
    private long connectionStartTime;

    LoggingSQLInterceptor() {
    }

    public void onConnectionTaken(Connection connection, ConnectionPoolState connectionPoolState) {
        this.connectionStartTime = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info(String.format("%dms Connection taken. borrowed : %d", connectionPoolState.getTimeToBorrow(), connectionPoolState.getBorrowedCount()));
        }
    }

    public void onConnectionReplaced(Connection connection, ConnectionPoolState connectionPoolState) {
        if (log.isInfoEnabled()) {
            long borrowTime = System.currentTimeMillis() - this.connectionStartTime;
            log.info(String.format("%dms Connection returned. borrowed : %d", borrowTime, connectionPoolState.getBorrowedCount()));
        }
    }

    public void beforeExecution(String sqlString, List<String> parameterValues, Statement statement) {
        this.startTime = System.currentTimeMillis();
    }

    public void afterSuccessfulExecution(String sqlString, List<String> parameterValues, Statement statement, ResultSet resultSet, int rowsUpdated) {
        this.afterExecutionImpl(sqlString, parameterValues, statement, null);
    }

    public void onException(String sqlString, List<String> parameterValues, Statement statement, SQLException sqlException) {
        this.afterExecutionImpl(sqlString, parameterValues, statement, sqlException);
    }

    private void afterExecutionImpl(String sqlString, List<String> parameterValues, Statement statement, SQLException possibleException) {
        if (log.isInfoEnabled()) {
            long ms = System.currentTimeMillis() - this.startTime;
            String msg = ms + "ms " + OfBizLogHelper.formatSQL(sqlString, parameterValues);
            if (possibleException != null) {
                log.error(msg, (Throwable)possibleException);
            } else {
                log.info(msg);
                if (log.isDebugEnabled()) {
                    log.debug(OfBizLogHelper.logTheCallStack());
                }
            }
        }
    }
}

