/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.query.DirectoryQueries;
import com.atlassian.jira.bc.user.search.DuplicateUserRemovalService;
import com.atlassian.jira.bc.user.search.UserSearchIssueContext;
import com.atlassian.jira.bc.user.search.UserSearchUtilities;
import com.atlassian.jira.crowd.embedded.JiraCrowdDAO;
import com.atlassian.jira.crowd.embedded.UserDTOUser;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.mention.stats.UserSearchServiceStats;
import com.atlassian.jira.model.querydsl.SchemePermissionsDTO;
import com.atlassian.jira.model.querydsl.UserDTO;
import com.atlassian.jira.permission.IssueUserSearchManager;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionSchemeLogic;
import com.atlassian.jira.permission.PermissionSchemeLogicImpl;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.permission.SchemePermissionsDAO;
import com.atlassian.jira.permission.UserSearchConfiguration;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.SchemeType;
import com.atlassian.jira.security.SecurityTypeManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIssueUserSearchManager
implements IssueUserSearchManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultIssueUserSearchManager.class);
    private static final int MAX_TOP = UserSearchConfiguration.getMaxTopReturnedUsersValue();
    private static final Comparator<ApplicationUser> DISPLAY_ORDER_COMPARATOR = Comparator.comparing(ApplicationUser::getDisplayName, Comparator.comparing(IdentifierUtils::toLowerCase)).thenComparing(ApplicationUser::getUsername, Comparator.comparing(IdentifierUtils::toLowerCase));
    private final JiraCrowdDAO jiraCrowdDAO;
    private final SchemePermissionsDAO schemePermissionsDAO;
    private final DirectoryManager directoryManager;
    private final UserSearchServiceStats userSearchServiceStats;
    private final DuplicateUserRemovalService duplicateUserRemovalService;
    private final SecurityTypeManager securityTypeManager;
    private final PermissionContextFactory permissionContextFactory;
    private final AtomicLong unoptimisedSecurityTypeWarningCounter = new AtomicLong();

    public DefaultIssueUserSearchManager(JiraCrowdDAO jiraCrowdDAO, SchemePermissionsDAO schemePermissionsDAO, DirectoryManager directoryManager, UserSearchServiceStats userSearchServiceStats, DuplicateUserRemovalService duplicateUserRemovalService, SecurityTypeManager securityTypeManager, PermissionContextFactory permissionContextFactory) {
        this.jiraCrowdDAO = jiraCrowdDAO;
        this.schemePermissionsDAO = schemePermissionsDAO;
        this.directoryManager = directoryManager;
        this.userSearchServiceStats = userSearchServiceStats;
        this.duplicateUserRemovalService = duplicateUserRemovalService;
        this.securityTypeManager = securityTypeManager;
        this.permissionContextFactory = permissionContextFactory;
    }

    @Override
    public List<ApplicationUser> findTopMentionableUsers(String searchName, UserSearchIssueContext userSearchIssueContext, int topN) throws UnsupportedOperationException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        PermissionSchemeLogic permissionSchemeLogic = this.getPermissionSchemeLogic(userSearchIssueContext, ProjectPermissions.BROWSE_PROJECTS, true);
        List<ApplicationUser> result = this.findTopUsers(searchName, userSearchIssueContext, topN, permissionSchemeLogic);
        this.userSearchServiceStats.findTopMentionableUsers(userSearchIssueContext.getIssue().isPresent(), searchName.length(), topN, result.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return result;
    }

    @Override
    public List<ApplicationUser> findTopAssignableUsers(String searchName, UserSearchIssueContext userSearchIssueContext, int topN) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        PermissionSchemeLogic permissionSchemeLogic = this.getPermissionSchemeLogic(userSearchIssueContext, ProjectPermissions.ASSIGNABLE_USER, false);
        List<ApplicationUser> result = this.findTopUsers(searchName, userSearchIssueContext, topN, permissionSchemeLogic);
        this.userSearchServiceStats.findTopAssignableUsers(userSearchIssueContext.getIssue().isPresent(), searchName.length(), topN, result.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return result;
    }

    @Override
    public List<ApplicationUser> findTopWatcherUsers(String searchName, UserSearchIssueContext userSearchIssueContext, int topN) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        PermissionSchemeLogic permissionSchemeLogic = this.getPermissionSchemeLogic(userSearchIssueContext, ProjectPermissions.BROWSE_PROJECTS, false);
        List<ApplicationUser> result = this.findTopUsers(searchName, userSearchIssueContext, topN, permissionSchemeLogic);
        this.userSearchServiceStats.findTopMentionableUsers(userSearchIssueContext.getIssue().isPresent(), searchName.length(), topN, result.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return result;
    }

    @Override
    public List<ApplicationUser> findTopUsers(String searchName, UserSearchIssueContext userSearchIssueContext, int topN, ProjectPermissionKey permissionKey, boolean forceReporterAndAssignee) {
        PermissionSchemeLogic permissionSchemeLogic = this.getPermissionSchemeLogic(userSearchIssueContext, permissionKey, forceReporterAndAssignee);
        return this.findTopUsers(searchName, userSearchIssueContext, topN, permissionSchemeLogic);
    }

    @Override
    public List<ApplicationUser> findTopUsers(String searchName, UserSearchIssueContext userSearchIssueContext, int topN, PermissionSchemeLogic permissionSchemeLogic) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Preconditions.checkNotNull((Object)searchName, (Object)"searchName must not be null");
        if (permissionSchemeLogic.nobodyAllowed()) {
            return ImmutableList.of();
        }
        List<SecurityTypeWithParameter> unsupportedSecurityTypes = this.getUnsupportedSecurityTypes(permissionSchemeLogic, userSearchIssueContext);
        ProjectPermissionKey permissionKey = permissionSchemeLogic.getPermissionKey();
        long permissionSchemeId = permissionSchemeLogic.getPermissionSchemeId();
        TreeSet<ApplicationUser> matchingUsers = new TreeSet<ApplicationUser>(Comparator.comparing(ApplicationUser::getUsername, Comparator.comparing(IdentifierUtils::toLowerCase)).thenComparing(ApplicationUser::getDirectoryId));
        matchingUsers.addAll(this.findInIssueDefinedUsers(searchName, userSearchIssueContext, permissionSchemeLogic));
        int reasonableTopN = DefaultIssueUserSearchManager.reasonableMax(topN);
        int internalTopN = this.internalSearchLimit(topN, unsupportedSecurityTypes.size());
        int perSecurityTypeTopN = this.internalSearchLimit(topN, 0L);
        if (permissionSchemeLogic.allAllowed()) {
            matchingUsers.addAll(this.mapDTOUserToApplicationUser(this.jiraCrowdDAO.findTopUsers(searchName, internalTopN)));
        } else {
            matchingUsers.addAll(this.mapDTOUserToApplicationUser(this.findTopUsersWithPermissionInIssue(searchName, permissionSchemeId, userSearchIssueContext, permissionKey, internalTopN, permissionSchemeLogic)));
            matchingUsers.addAll(this.mapDTOUserToApplicationUser(this.findTopUsersWithPermissionInIssueFromGroups(searchName, permissionSchemeId, userSearchIssueContext, internalTopN, this.isNestedGroupsEnabledForAnyDirectory(), permissionSchemeLogic, permissionKey)));
            matchingUsers.addAll(this.findTopUsersFromSecurityTypes(searchName, userSearchIssueContext, unsupportedSecurityTypes, topN, perSecurityTypeTopN));
        }
        TreeSet<ApplicationUser> uniqueMatchingUsers = this.hasToCheckForDuplicates(unsupportedSecurityTypes.size()) ? this.duplicateUserRemovalService.getUniqueApplicationUsers(matchingUsers) : matchingUsers;
        List<ApplicationUser> result = uniqueMatchingUsers.stream().sorted(DISPLAY_ORDER_COMPARATOR).limit(reasonableTopN).collect(Collectors.toList());
        Set<String> unsupportedPermissionTypes = unsupportedSecurityTypes.stream().map(securityTypeWithParameter -> securityTypeWithParameter.getSecurityType().getType()).collect(Collectors.toSet());
        this.userSearchServiceStats.findTopUsersInternal(unsupportedPermissionTypes, result.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return result;
    }

    private PermissionSchemeLogic getPermissionSchemeLogic(UserSearchIssueContext userSearchIssueContext, ProjectPermissionKey permissionKey, boolean forceReporterAndAssignee) {
        Long permissionSchemeId = this.schemePermissionsDAO.getPermissionSchemeIdFor(userSearchIssueContext.getProjectId());
        Preconditions.checkState((permissionSchemeId != null ? 1 : 0) != 0, (String)"Could not find permissions scheme for project: %s", (Object)userSearchIssueContext.getProjectId());
        List<SchemePermissionsDTO> schemePermissions = this.schemePermissionsDAO.getSchemePermissions(permissionSchemeId, permissionKey);
        PermissionSchemeLogic permissionSchemeLogic = forceReporterAndAssignee ? PermissionSchemeLogicImpl.createWithReporterAndAssigneeOverride(permissionKey, permissionSchemeId, schemePermissions) : PermissionSchemeLogicImpl.create(permissionKey, permissionSchemeId, schemePermissions);
        this.recordPermissionSchemeLogicStats(permissionSchemeLogic);
        return permissionSchemeLogic;
    }

    private boolean hasToCheckForDuplicates(int unsupportedSecurityTypeCount) {
        if (unsupportedSecurityTypeCount > 0) {
            return true;
        }
        long activeDirectoryCount = this.directoryManager.searchDirectories(DirectoryQueries.allDirectories()).stream().filter(Directory::isActive).count();
        return activeDirectoryCount > 1L;
    }

    private List<ApplicationUser> mapDTOUserToApplicationUser(Collection<UserDTO> users) {
        return users.stream().map(UserDTOUser::from).map(ApplicationUsers::from).collect(Collectors.toList());
    }

    private List<ApplicationUser> findInIssueDefinedUsers(String searchName, UserSearchIssueContext userSearchIssueContext, PermissionSchemeLogic permissionSchemeLogic) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        List issueDefinedUsers = Stream.of(permissionSchemeLogic.isIssueUserTypeReporter() ? userSearchIssueContext.getIssue().map(Issue::getReporter) : Optional.empty(), permissionSchemeLogic.isIssueUserTypeAssignee() ? userSearchIssueContext.getIssue().map(Issue::getAssignee) : Optional.empty(), permissionSchemeLogic.isIssueUserTypeProjectLead() ? Optional.ofNullable(userSearchIssueContext.getProject().getProjectLead()) : Optional.empty()).filter(Optional::isPresent).map(Optional::get).distinct().collect(Collectors.toList());
        List<ApplicationUser> result = issueDefinedUsers.stream().filter(user -> UserSearchUtilities.userSearchMatchUser(user, searchName)).collect(Collectors.toList());
        this.userSearchServiceStats.findInIssueDefinedUsers(searchName.length(), result.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return result;
    }

    private Set<UserDTO> findTopUsersWithPermissionInIssue(String userSearchName, long schemeId, UserSearchIssueContext userSearchIssueContext, ProjectPermissionKey projectPermissionKey, int topN, PermissionSchemeLogic permissionSchemeLogic) {
        if (!permissionSchemeLogic.anyUserType()) {
            return ImmutableSet.of();
        }
        TreeSet<UserDTO> result = new TreeSet<UserDTO>(Comparator.comparing(UserDTO::getLowerDisplayName).thenComparing(UserDTO::getLowerUserName));
        Project project = userSearchIssueContext.getProject();
        Stopwatch stopwatch = Stopwatch.createStarted();
        int sqlCount = 0;
        if (permissionSchemeLogic.isUserTypeUser()) {
            result.addAll(this.schemePermissionsDAO.findTopUsersFromTypeUser(userSearchName, schemeId, projectPermissionKey, topN));
            ++sqlCount;
        }
        if (permissionSchemeLogic.isUserTypeProjectRole()) {
            result.addAll(this.schemePermissionsDAO.findTopUsersFromTypeProjectRoleUsers(userSearchName, schemeId, project.getId(), projectPermissionKey, topN));
            ++sqlCount;
        }
        if (userSearchIssueContext.getIssueId().isPresent() && permissionSchemeLogic.isUserTypeCustomField()) {
            result.addAll(this.schemePermissionsDAO.findTopUsersFromUserCF(userSearchName, schemeId, (Long)userSearchIssueContext.getIssueId().get(), projectPermissionKey, topN));
            ++sqlCount;
        }
        this.userSearchServiceStats.findTopUsersWithPermissionInIssue(sqlCount, result.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
        log.debug("SchemePermissionsDAO#findTopMentionableUsersInIssue: input.userSearchName:{}, input.schemeId:{}, input.projectPermissionKey:{}, input.permissionSchemeLogic: {}result.size:{}, timeInMillis:{}, numberOfSQLQueries:{}", new Object[]{userSearchName, schemeId, projectPermissionKey.permissionKey(), permissionSchemeLogic, result.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS), sqlCount});
        return result;
    }

    private Set<Group> findGroupsFrom(long schemeId, UserSearchIssueContext userSearchIssueContext, ProjectPermissionKey projectPermissionKey, PermissionSchemeLogic permissionSchemeLogic) {
        Optional issueId;
        Preconditions.checkState((boolean)permissionSchemeLogic.anyGroupType());
        Preconditions.checkNotNull((Object)userSearchIssueContext.getProject());
        HashSet<String> result = new HashSet<String>();
        Stopwatch stopwatch = Stopwatch.createStarted();
        int sqlCount = 0;
        if (permissionSchemeLogic.isGroupTypeGroup()) {
            result.addAll(this.schemePermissionsDAO.findGroupsFromTypeGroup(schemeId, projectPermissionKey));
            ++sqlCount;
        }
        if (permissionSchemeLogic.isGroupTypeProjectRole()) {
            result.addAll(this.schemePermissionsDAO.findGroupsFromTypeProjectRoleGroup(schemeId, userSearchIssueContext.getProjectId(), projectPermissionKey));
            ++sqlCount;
        }
        if ((issueId = userSearchIssueContext.getIssueId()).isPresent() && permissionSchemeLogic.isGroupTypeCustomField()) {
            result.addAll(this.schemePermissionsDAO.findGroupsFromGroupCF(schemeId, (Long)issueId.get(), projectPermissionKey));
            result.addAll(this.schemePermissionsDAO.findGroupsFromSelectCF(schemeId, (Long)issueId.get(), projectPermissionKey));
            sqlCount += 2;
        }
        if (permissionSchemeLogic.isGroupTypeApplicationRole()) {
            result.addAll(this.schemePermissionsDAO.findGroupsFromApplicationRole(schemeId, projectPermissionKey));
            ++sqlCount;
        }
        this.userSearchServiceStats.findGroupsFrom(sqlCount, result.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
        log.debug("SchemePermissionsDAO#findGroupsFrom: input.schemeId:{}, input.projectPermissionKey:{}, result.size:{}, timeInMillis:{}, numberOfSQLQueries:{}", new Object[]{schemeId, projectPermissionKey.permissionKey(), result.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS), sqlCount});
        return result.stream().map(ImmutableGroup::new).collect(Collectors.toSet());
    }

    private boolean isNestedGroupsEnabledForAnyDirectory() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        List directories = this.directoryManager.searchDirectories(DirectoryQueries.allDirectories());
        int exceptionCount = 0;
        for (Directory directory : directories) {
            try {
                if (!this.directoryManager.supportsNestedGroups(directory.getId().longValue())) continue;
                this.userSearchServiceStats.isNestedGroupsEnabledForAnyDirectory(exceptionCount, directories.size(), true, stopwatch.elapsed(TimeUnit.MILLISECONDS));
                return true;
            }
            catch (DirectoryInstantiationException | DirectoryNotFoundException e) {
                ++exceptionCount;
                log.warn("Problem occurred while checking directory: {} for support of nested groups", (Object)directory.getName(), (Object)e);
            }
        }
        this.userSearchServiceStats.isNestedGroupsEnabledForAnyDirectory(exceptionCount, directories.size(), false, stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return false;
    }

    private List<UserDTO> findTopUsersWithPermissionInIssueFromGroups(String searchName, long schemeId, UserSearchIssueContext userSearchIssueContext, int topN, boolean nested, PermissionSchemeLogic permissionSchemeLogic, ProjectPermissionKey permissionKey) {
        if (!permissionSchemeLogic.anyGroupType()) {
            return ImmutableList.of();
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        Set<Group> allGroupsForProject = this.findGroupsFrom(schemeId, userSearchIssueContext, permissionKey, permissionSchemeLogic);
        if (nested) {
            allGroupsForProject = this.jiraCrowdDAO.findNestedGroupsOf(allGroupsForProject);
        }
        List<UserDTO> result = this.jiraCrowdDAO.findTopUsersWithNameInGroups(searchName, allGroupsForProject, topN);
        this.userSearchServiceStats.findTopUsersWithPermissionInIssueFromGroups(result.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return result;
    }

    private List<ApplicationUser> findTopUsersFromSecurityTypes(String searchName, UserSearchIssueContext userSearchIssueContext, List<SecurityTypeWithParameter> securityTypesAndParameters, int allSecurityTypesTopN, int perSecurityTypeTopN) {
        PermissionContext permissionContext = userSearchIssueContext.getIssue().map(arg_0 -> ((PermissionContextFactory)this.permissionContextFactory).getPermissionContext(arg_0)).orElseGet(() -> this.permissionContextFactory.getPermissionContext(userSearchIssueContext.getProject()));
        return securityTypesAndParameters.stream().flatMap(securityTypeAndParameter -> securityTypeAndParameter.getSecurityType().getUsers(permissionContext, securityTypeAndParameter.getParameter(), searchName, perSecurityTypeTopN).stream()).sorted(DISPLAY_ORDER_COMPARATOR).limit(allSecurityTypesTopN).collect(Collectors.toList());
    }

    private List<SecurityTypeWithParameter> getUnsupportedSecurityTypes(PermissionSchemeLogic permissionSchemeLogic, UserSearchIssueContext userSearchIssueContext) {
        List<SecurityTypeWithParameter> unsupportedSecurityTypes = permissionSchemeLogic.unsupportedPermissionTypes().stream().map(permissionTypeWithParameter -> new SecurityTypeWithParameter(this.securityTypeManager.getSecurityType(permissionTypeWithParameter.getType()), permissionTypeWithParameter.getParameter())).collect(Collectors.toList());
        this.warnAboutPossiblyUnoptimisedSecurityTypes(unsupportedSecurityTypes, userSearchIssueContext);
        return unsupportedSecurityTypes;
    }

    @VisibleForTesting
    void warnAboutPossiblyUnoptimisedSecurityTypes(List<SecurityTypeWithParameter> unsupportedSecurityTypesWithParameters, UserSearchIssueContext userSearchIssueContext) {
        List unoptimisedPermissionTypes = unsupportedSecurityTypesWithParameters.stream().map(SecurityTypeWithParameter::getSecurityType).filter(securityType -> {
            Class<?> clazz = securityType.getClass();
            try {
                Method m = clazz.getMethod("getUsers", PermissionContext.class, String.class, String.class, Integer.TYPE);
                return !m.getDeclaringClass().equals(clazz);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }).map(SchemeType::getType).sorted().collect(Collectors.toList());
        if (unoptimisedPermissionTypes.isEmpty()) {
            return;
        }
        if (this.unoptimisedSecurityTypeWarningCounter.getAndIncrement() % 100L == 0L) {
            List projectKeys = userSearchIssueContext.getProjects().stream().map(Project::getKey).collect(Collectors.toList());
            log.warn("Permission types: {} in projects: {} use the default unoptimised SecurityType#getUsers implementation. Please provide an optimised implementation.", unoptimisedPermissionTypes, projectKeys);
        }
    }

    private static int reasonableMax(int maxResults) {
        if (maxResults > MAX_TOP) {
            log.warn("Requested top N={}, which is greater than the max top allowed: {}. Enable trace logging to see the stack trace.", (Object)maxResults, (Object)MAX_TOP);
            if (log.isTraceEnabled()) {
                log.trace("Requested top N={} from:", (Object)maxResults, (Object)new Throwable());
            }
            return MAX_TOP;
        }
        return maxResults;
    }

    private int internalSearchLimit(long baseMaxResults, long unsupportedSecurityTypeCount) {
        int activeDirectoryCount = (int)this.directoryManager.searchDirectories(DirectoryQueries.allDirectories()).stream().filter(Directory::isActive).count();
        long maxResults = Math.multiplyExact(baseMaxResults, (long)activeDirectoryCount + unsupportedSecurityTypeCount);
        int maxResultsCapped = (int)Math.min(maxResults, (long)MAX_TOP);
        log.debug("Calculating internal search limit: baseMaxResults={}, activeDirectoryCount={}, unsupportedSecurityTypeCount={}, maxResults={}, maxResultsCapped={}", new Object[]{baseMaxResults, activeDirectoryCount, unsupportedSecurityTypeCount, maxResults, maxResultsCapped});
        return maxResultsCapped;
    }

    private void recordPermissionSchemeLogicStats(PermissionSchemeLogic permissionSchemeLogic) {
        this.userSearchServiceStats.permissionSchemeLogic(permissionSchemeLogic);
    }

    static class SecurityTypeWithParameter {
        @Nonnull
        private final SecurityType securityType;
        @Nullable
        private final String parameter;

        SecurityTypeWithParameter(@Nonnull SecurityType securityType, @Nullable String parameter) {
            this.securityType = securityType;
            this.parameter = parameter;
        }

        @Nonnull
        public SecurityType getSecurityType() {
            return this.securityType;
        }

        @Nullable
        public String getParameter() {
            return this.parameter;
        }
    }
}

