/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.WorkflowPermission;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Set;

public class DefaultWorkflowPermission
implements WorkflowPermission {
    public static final String PREFIX = "jira.permission.";
    public static final String PREFIX_PARENT = "jira.permission.subtasks.";
    private SecurityType grantType;
    private boolean parentPermission;
    private ProjectPermissionKey permission;
    private String value;

    protected DefaultWorkflowPermission(ProjectPermissionKey permission, SecurityType grantType, String value, boolean isParentPermission) {
        this.grantType = grantType;
        this.parentPermission = isParentPermission;
        this.permission = permission;
        this.value = value;
    }

    @Override
    public Set<ApplicationUser> getUsers(PermissionContext ctx) {
        return this.grantType.getUsers(ctx, this.value);
    }

    @Override
    public boolean allows(ProjectPermissionKey permission, Issue issue, ApplicationUser user) {
        return user == null ? this.grantType.hasPermission(issue, this.value) : this.grantType.hasPermission(issue, this.value, user, false);
    }

    public String toString() {
        return (this.parentPermission ? "parent " : "") + "workflow perm granting " + this.permission.permissionKey() + " to " + this.grantType.getDisplayName() + " '" + this.value + "'";
    }
}

