/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.ProjectPermissionHelper;
import com.atlassian.jira.project.Project;
import java.util.List;
import java.util.Objects;
import org.apache.log4j.Logger;

public class ProjectPermissionHelperImpl
implements ProjectPermissionHelper {
    private static final Logger log = Logger.getLogger(ProjectPermissionHelperImpl.class);
    private final PermissionSchemeManager permissionSchemeManager;

    public ProjectPermissionHelperImpl(PermissionSchemeManager permissionSchemeManager) {
        this.permissionSchemeManager = permissionSchemeManager;
    }

    @Override
    public boolean hasExtPermission(List<Project> projects) {
        if (Objects.isNull(projects) || projects.size() != 1) {
            log.debug((Object)"Returning 'false' for `hasExtPermission` because the given projects are null or with size != 1");
            return false;
        }
        return this.hasExtPermission(projects.get(0));
    }

    @Override
    public boolean hasExtPermission(Project project) {
        return this.permissionSchemeManager.hasExtendedProjectAdministration(project);
    }
}

