/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission.management.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class ProjectExtPermissionBean {
    private String key;
    private String name;
    private String description;
    private String endpointURI;
    private Boolean checked;

    public ProjectExtPermissionBean(String key, String name, String permissionDesc, String endpointURI, Boolean checked) {
        this.key = key;
        this.name = name;
        this.description = permissionDesc;
        this.endpointURI = endpointURI;
        this.checked = checked;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEndpointURI() {
        return this.endpointURI;
    }

    public Boolean getChecked() {
        return this.checked;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ProjectExtPermissionBean data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectExtPermissionBean that = (ProjectExtPermissionBean)o;
        return Objects.equal((Object)this.key, (Object)that.key) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.endpointURI, (Object)that.endpointURI) && Objects.equal((Object)this.checked, (Object)that.checked);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.name, this.description, this.endpointURI, this.checked});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key).add("name", (Object)this.name).add("description", (Object)this.description).add("endpointURI", (Object)this.endpointURI).add("checked", (Object)this.checked).toString();
    }

    public static final class Builder {
        private String key;
        private String name;
        private String description;
        private String endpointURI;
        private Boolean checked;

        private Builder() {
        }

        private Builder(ProjectExtPermissionBean initialData) {
            this.key = initialData.key;
            this.name = initialData.name;
            this.description = initialData.description;
            this.endpointURI = initialData.endpointURI;
            this.checked = initialData.checked;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setEndpointURI(String endpointURI) {
            this.endpointURI = endpointURI;
            return this;
        }

        public Builder setChecked(Boolean checked) {
            this.checked = checked;
            return this;
        }

        public ProjectExtPermissionBean build() {
            return new ProjectExtPermissionBean(this.key, this.name, this.description, this.endpointURI, this.checked);
        }
    }
}

