/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission.management.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class ProjectPermissionRenderingSectionBean {
    private String sectionType;
    private String heading;
    private List<String> permissions;

    public ProjectPermissionRenderingSectionBean() {
    }

    private ProjectPermissionRenderingSectionBean(String sectionType, String heading, Iterable<String> permissions) {
        this.sectionType = sectionType;
        this.heading = heading;
        this.permissions = permissions != null ? ImmutableList.copyOf(permissions) : null;
    }

    public String getSectionType() {
        return this.sectionType;
    }

    public void setSectionType(String sectionType) {
        this.sectionType = sectionType;
    }

    public String getHeading() {
        return this.heading;
    }

    public void setHeading(String heading) {
        this.heading = heading;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions != null ? ImmutableList.copyOf(permissions) : null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ProjectPermissionRenderingSectionBean data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectPermissionRenderingSectionBean that = (ProjectPermissionRenderingSectionBean)o;
        return Objects.equal((Object)this.sectionType, (Object)that.sectionType) && Objects.equal((Object)this.heading, (Object)that.heading) && Objects.equal(this.permissions, that.permissions);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sectionType, this.heading, this.permissions});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sectionType", (Object)this.sectionType).add("heading", (Object)this.heading).add("permissions", this.permissions).toString();
    }

    public static final class Builder {
        private String sectionType;
        private String heading;
        private List<String> permissions = Lists.newArrayList();

        private Builder() {
        }

        private Builder(ProjectPermissionRenderingSectionBean initialData) {
            this.sectionType = initialData.sectionType;
            this.heading = initialData.heading;
            this.permissions = initialData.permissions;
        }

        public Builder setSectionType(String sectionType) {
            this.sectionType = sectionType;
            return this;
        }

        public Builder setHeading(String heading) {
            this.heading = heading;
            return this;
        }

        public Builder setPermissions(List<String> permissions) {
            this.permissions = permissions;
            return this;
        }

        public Builder addPermission(String permission) {
            this.permissions.add(permission);
            return this;
        }

        public Builder addPermissions(Iterable<String> permissions) {
            for (String permission : permissions) {
                this.addPermission(permission);
            }
            return this;
        }

        public ProjectPermissionRenderingSectionBean build() {
            return new ProjectPermissionRenderingSectionBean(this.sectionType, this.heading, this.permissions);
        }
    }
}

