/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission.management.beans;

import com.atlassian.jira.permission.management.beans.ProjectPermissionBean;
import com.atlassian.jira.permission.management.beans.ProjectPermissionOperationResultBean;
import com.atlassian.jira.permission.management.beans.ProjectPermissionRenderingBean;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class ProjectPermissionSchemeBean {
    Long id;
    String name;
    String description;
    List<ProjectPermissionBean> permissions;
    ProjectPermissionRenderingBean displayRendering;
    ProjectPermissionOperationResultBean operationResult;

    public ProjectPermissionSchemeBean() {
    }

    private ProjectPermissionSchemeBean(Long id, String name, String description, Iterable<ProjectPermissionBean> permissions, ProjectPermissionRenderingBean displayRendering, ProjectPermissionOperationResultBean operationResult) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.permissions = permissions != null ? ImmutableList.copyOf(permissions) : null;
        this.displayRendering = displayRendering;
        this.operationResult = operationResult;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<ProjectPermissionBean> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<ProjectPermissionBean> permissions) {
        this.permissions = permissions != null ? ImmutableList.copyOf(permissions) : null;
    }

    public ProjectPermissionRenderingBean getDisplayRendering() {
        return this.displayRendering;
    }

    public void setDisplayRendering(ProjectPermissionRenderingBean displayRendering) {
        this.displayRendering = displayRendering;
    }

    public ProjectPermissionOperationResultBean getOperationResult() {
        return this.operationResult;
    }

    public void setOperationResult(ProjectPermissionOperationResultBean operationResult) {
        this.operationResult = operationResult;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ProjectPermissionSchemeBean data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectPermissionSchemeBean that = (ProjectPermissionSchemeBean)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal(this.permissions, that.permissions) && Objects.equal((Object)this.displayRendering, (Object)that.displayRendering) && Objects.equal((Object)this.operationResult, (Object)that.operationResult);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.description, this.permissions, this.displayRendering, this.operationResult});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("description", (Object)this.description).add("permissions", this.permissions).add("displayRendering", (Object)this.displayRendering).add("operationResult", (Object)this.operationResult).toString();
    }

    public static final class Builder {
        private Long id;
        private String name;
        private String description;
        private List<ProjectPermissionBean> permissions = Lists.newArrayList();
        private ProjectPermissionRenderingBean displayRendering;
        private ProjectPermissionOperationResultBean operationResult;

        private Builder() {
        }

        private Builder(ProjectPermissionSchemeBean initialData) {
            this.id = initialData.id;
            this.name = initialData.name;
            this.description = initialData.description;
            this.permissions = initialData.permissions;
            this.displayRendering = initialData.displayRendering;
            this.operationResult = initialData.operationResult;
        }

        public Builder setId(Long id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setPermissions(List<ProjectPermissionBean> permissions) {
            this.permissions = permissions;
            return this;
        }

        public Builder addPermission(ProjectPermissionBean permission) {
            this.permissions.add(permission);
            return this;
        }

        public Builder addPermissions(Iterable<ProjectPermissionBean> permissions) {
            for (ProjectPermissionBean permission : permissions) {
                this.addPermission(permission);
            }
            return this;
        }

        public Builder setDisplayRendering(ProjectPermissionRenderingBean displayRendering) {
            this.displayRendering = displayRendering;
            return this;
        }

        public Builder setOperationResult(ProjectPermissionOperationResultBean operationResult) {
            this.operationResult = operationResult;
            return this;
        }

        public ProjectPermissionSchemeBean build() {
            return new ProjectPermissionSchemeBean(this.id, this.name, this.description, this.permissions, this.displayRendering, this.operationResult);
        }
    }
}

