/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.plugin.PluginDirectoryLoaderFactory;
import com.atlassian.jira.plugin.PluginFactoryAndLoaderRegistrar;
import com.atlassian.jira.plugin.PluginLoaderFactory;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.loaders.ClassPathPluginLoader;
import com.atlassian.plugin.loaders.PluginLoader;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPluginLoaderFactory
implements PluginLoaderFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultPluginLoaderFactory.class);
    private final PluginFactoryAndLoaderRegistrar pluginFactoryAndLoaderRegistrar;
    private final PluginDirectoryLoaderFactory pluginDirectoryLoaderFactory;
    private final JiraProperties jiraSystemProperties;

    public DefaultPluginLoaderFactory(JiraProperties jiraSystemProperties, PluginFactoryAndLoaderRegistrar pluginFactoryAndLoaderRegistrar, PluginDirectoryLoaderFactory pluginDirectoryLoaderFactory) {
        this.jiraSystemProperties = jiraSystemProperties;
        this.pluginFactoryAndLoaderRegistrar = pluginFactoryAndLoaderRegistrar;
        this.pluginDirectoryLoaderFactory = pluginDirectoryLoaderFactory;
    }

    @Override
    public List<PluginLoader> getPluginLoaders() {
        PluginLoader pluginLoader;
        List<PluginFactory> pluginFactories = this.pluginFactoryAndLoaderRegistrar.getDefaultPluginFactories();
        CollectionBuilder pluginLoaderBuilder = CollectionBuilder.newBuilder();
        pluginLoaderBuilder.addAll(this.pluginFactoryAndLoaderRegistrar.getDefaultSystemPluginLoaders());
        pluginLoaderBuilder.add((Object)new ClassPathPluginLoader());
        if (this.jiraSystemProperties.isBundledPluginsDisabled()) {
            log.warn("Bundled plugins have been disabled. Removing bundled plugin loader.");
        } else {
            pluginLoaderBuilder.add((Object)this.pluginFactoryAndLoaderRegistrar.getBundledPluginsLoader(pluginFactories));
        }
        if (this.jiraSystemProperties.isCustomPathPluginsEnabled() && (pluginLoader = this.pluginFactoryAndLoaderRegistrar.getCustomDirectoryPluginLoader(pluginFactories)) != null) {
            pluginLoaderBuilder.add((Object)pluginLoader);
        }
        if (this.jiraSystemProperties.isPluginsRosterFileEnabled() && (pluginLoader = this.pluginFactoryAndLoaderRegistrar.getRosterFilePluginLoader(pluginFactories)) != null) {
            pluginLoaderBuilder.add((Object)pluginLoader);
        }
        pluginLoaderBuilder.add((Object)this.pluginDirectoryLoaderFactory.getDirectoryPluginLoader(pluginFactories));
        return pluginLoaderBuilder.asList();
    }
}

