/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.attachment;

import com.atlassian.jira.plugin.attachment.AttachmentArchive;
import com.atlassian.jira.plugin.attachment.AttachmentArchiveEntry;
import com.atlassian.jira.plugin.attachment.AttachmentArchiveEntryBuilder;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect
public class AttachmentArchiveImpl
implements AttachmentArchive {
    private static final Logger log = LoggerFactory.getLogger(AttachmentArchiveImpl.class);
    public static final AttachmentArchive DOC_EXAMPLE;
    private static final Function<JSONObject, AttachmentArchiveEntry> FROM_JSON;
    private final List<AttachmentArchiveEntry> entries;
    private final int totalEntryCount;

    public static Iterable<JSONObject> serialize(List<AttachmentArchiveEntry> entries) {
        return Iterables.transform(entries, (Function)new Function<AttachmentArchiveEntry, JSONObject>(){

            public JSONObject apply(AttachmentArchiveEntry entry) {
                try {
                    JSONObject json = new JSONObject();
                    json.put("entryIndex", entry.getEntryIndex());
                    json.put("name", (Object)entry.getName());
                    json.put("size", entry.getSize());
                    json.put("mediaType", (Object)entry.getMediaType());
                    return json;
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static AttachmentArchive fromJSONArrayQuiet(String jsonArrayString, int maxSize) {
        try {
            JSONArray jsonArray = new JSONArray(jsonArrayString);
            ImmutableList.Builder builder = ImmutableList.builder();
            int maxIndex = Math.min(jsonArray.length(), maxSize);
            for (int i = 0; i < maxIndex; ++i) {
                builder.add(FROM_JSON.apply((Object)jsonArray.getJSONObject(i)));
            }
            ImmutableList entries = builder.build();
            return new AttachmentArchiveImpl((List<AttachmentArchiveEntry>)entries, jsonArray.length());
        }
        catch (JSONException ignore) {
            log.error(String.format("Invalid jsonArray supplied: %s", jsonArrayString));
            return null;
        }
    }

    public AttachmentArchiveImpl(List<AttachmentArchiveEntry> entries, int totalEntryCount) {
        this.entries = entries;
        this.totalEntryCount = totalEntryCount;
    }

    @Override
    public List<AttachmentArchiveEntry> getEntries() {
        return this.entries;
    }

    @Override
    @JsonIgnore
    public boolean isMoreAvailable() {
        return this.totalEntryCount > this.entries.size();
    }

    @Override
    @JsonIgnore
    public int getTotalNumberOfEntriesAvailable() {
        return this.getTotalEntryCount();
    }

    @Override
    public int getTotalEntryCount() {
        return this.totalEntryCount;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.entries, this.totalEntryCount});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AttachmentArchiveImpl other = (AttachmentArchiveImpl)obj;
        return Objects.equal(this.entries, other.entries) && Objects.equal((Object)this.totalEntryCount, (Object)other.totalEntryCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entries", this.entries).add("totalEntryCount", this.totalEntryCount).toString();
    }

    static {
        ImmutableList entries = ImmutableList.of((Object)new AttachmentArchiveEntryBuilder().entryIndex(0).name("Allegro from Duet in C Major.mp3").size(1430174L).mediaType("audio/mpeg").build(), (Object)new AttachmentArchiveEntryBuilder().entryIndex(1).name("lrm.rtf").size(331L).mediaType("text/rtf").build());
        DOC_EXAMPLE = new AttachmentArchiveImpl((List<AttachmentArchiveEntry>)entries, 24);
        FROM_JSON = new Function<JSONObject, AttachmentArchiveEntry>(){

            public AttachmentArchiveEntry apply(JSONObject jsonObject) {
                try {
                    return new AttachmentArchiveEntryBuilder().entryIndex(jsonObject.getInt("entryIndex")).name(jsonObject.getString("name")).size(jsonObject.getLong("size")).mediaType(jsonObject.getString("mediaType")).build();
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

