/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ha;

import com.atlassian.jira.plugin.ha.PluginEventType;
import com.atlassian.jira.plugin.ha.PluginOperation;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class PluginCompositePredicate
implements Predicate<PluginOperation> {
    private Multimap<String, PluginEventType> exclusions = ArrayListMultimap.create();

    private PluginCompositePredicate() {
    }

    public boolean apply(@Nullable PluginOperation input) {
        boolean excluded = this.exclusions.containsEntry((Object)input.getPluginKey(), (Object)input.getPluginEventType());
        return !excluded;
    }

    private void addExclusions(Map<String, List<PluginEventType>> excludedTypes) {
        for (String pluginKey : excludedTypes.keySet()) {
            this.exclusions.putAll((Object)pluginKey, (Iterable)excludedTypes.get(pluginKey));
        }
    }

    public static class Builder {
        private PluginCompositePredicate pluginCompositePredicate = new PluginCompositePredicate();

        public Builder addExclusions(Map<String, List<PluginEventType>> exclusions) {
            this.pluginCompositePredicate.addExclusions(exclusions);
            return this;
        }

        public PluginCompositePredicate build() {
            return this.pluginCompositePredicate;
        }
    }
}

