/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ha;

import com.atlassian.jira.plugin.ClusterAwareJiraPluginController;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatedPluginManager {
    private final ClusterAwareJiraPluginController pluginController;
    private final PluginAccessor pluginAccessor;
    private static final Logger log = LoggerFactory.getLogger(ReplicatedPluginManager.class);

    public ReplicatedPluginManager(ClusterAwareJiraPluginController pluginController, PluginAccessor pluginAccessor) {
        this.pluginController = pluginController;
        this.pluginAccessor = pluginAccessor;
    }

    public void enablePlugin(String pluginKey) {
        this.pluginController.enablePluginsLocalOnly(pluginKey);
    }

    public void upgradePlugin(String pluginKey) {
        this.pluginController.scanForNewPlugins();
    }

    public void disablePlugin(String pluginKey) {
        this.pluginController.disablePluginLocalOnly(pluginKey);
    }

    public void enablePluginModule(String completeKey) {
        this.pluginController.enablePluginModuleLocalOnly(completeKey);
    }

    public void disablePluginModule(String completeKey) {
        this.pluginController.disablePluginModuleLocalOnly(completeKey);
    }

    public void installPlugin(String pluginKey) {
        this.pluginController.scanForNewPlugins();
    }

    public void uninstallPlugin(String pluginKey) {
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        if (plugin != null) {
            this.pluginController.uninstallLocalOnly(plugin);
        }
    }
}

