/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.index;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.index.ChangeHistorySearchExtractor;
import com.atlassian.jira.index.CommentSearchExtractor;
import com.atlassian.jira.index.EntitySearchExtractor;
import com.atlassian.jira.index.IssueSearchExtractor;
import com.atlassian.jira.index.SearchExtractorRegistrationManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryGroup;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.module.ModuleFactory;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Iterables;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class EntitySearchExtractorModuleDescriptorImpl
extends AbstractJiraModuleDescriptor<EntitySearchExtractor<?>> {
    private static final Map<Class<? extends EntitySearchExtractor>, RegistrationStrategy<?>> SUPPORTED_EXTRACTOR_TYPES = ImmutableMap.of(CommentSearchExtractor.class, (Object)new CommentSearchExtractorRegistrationStrategy(), ChangeHistorySearchExtractor.class, (Object)new ChangeHistorySearchExtractorRegistrationStrategy(), IssueSearchExtractor.class, (Object)new IssueSearchExtractorRegistrationStrategy());
    private RegistrationStrategy<?> registrationStrategy;

    public EntitySearchExtractorModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
    }

    @Override
    public void enabled() {
        super.enabled();
        this.registrationStrategy = this.registrationStrategy();
        this.registrationStrategy.register((EntitySearchExtractor)this.getModule());
    }

    @Override
    public void disabled() {
        this.registrationStrategy.unregister((EntitySearchExtractor)this.getModule());
        super.disabled();
    }

    public RegistrationStrategy<?> getRegistrationStrategy() {
        return this.registrationStrategy;
    }

    private <E> RegistrationStrategy<E> registrationStrategy() {
        return (RegistrationStrategy)Iterables.findFirst(SUPPORTED_EXTRACTOR_TYPES.entrySet(), (Predicate)new Predicate<Map.Entry<Class<? extends EntitySearchExtractor>, RegistrationStrategy<?>>>(){

            @Override
            public boolean test(Map.Entry<Class<? extends EntitySearchExtractor>, RegistrationStrategy<?>> entry) {
                return entry.getKey().isAssignableFrom(EntitySearchExtractorModuleDescriptorImpl.this.getModuleClass());
            }
        }).fold(new Supplier<RegistrationStrategy<E>>(){

            @Override
            public RegistrationStrategy<E> get() {
                throw new PluginException("Class " + EntitySearchExtractorModuleDescriptorImpl.this.getModuleClassName() + " is not implementing extractor for comment, issue or change history");
            }
        }, new Function<Map.Entry<Class<? extends EntitySearchExtractor>, RegistrationStrategy<?>>, RegistrationStrategy<E>>(){

            @Override
            public RegistrationStrategy<E> apply(Map.Entry<Class<? extends EntitySearchExtractor>, RegistrationStrategy<?>> entry) {
                return entry.getValue();
            }
        });
    }

    private static class IssueSearchExtractorRegistrationStrategy
    extends AbstractRegistrationStrategy<Issue, IssueSearchExtractor> {
        protected IssueSearchExtractorRegistrationStrategy() {
            super(IssueSearchExtractor.class, Issue.class);
        }
    }

    private static class ChangeHistorySearchExtractorRegistrationStrategy
    extends AbstractRegistrationStrategy<ChangeHistoryGroup, ChangeHistorySearchExtractor> {
        protected ChangeHistorySearchExtractorRegistrationStrategy() {
            super(ChangeHistorySearchExtractor.class, ChangeHistoryGroup.class);
        }
    }

    private static class CommentSearchExtractorRegistrationStrategy
    extends AbstractRegistrationStrategy<Comment, CommentSearchExtractor> {
        protected CommentSearchExtractorRegistrationStrategy() {
            super(CommentSearchExtractor.class, Comment.class);
        }
    }

    private static abstract class AbstractRegistrationStrategy<E, S extends EntitySearchExtractor<E>>
    implements RegistrationStrategy<E> {
        private final Class<S> searchExtractorType;
        private final Class<E> entityType;

        protected AbstractRegistrationStrategy(Class<S> searchExtractorType, Class<E> entityType) {
            this.searchExtractorType = searchExtractorType;
            this.entityType = entityType;
        }

        @Override
        public void register(EntitySearchExtractor<?> extractor) {
            if (this.searchExtractorType.isAssignableFrom(extractor.getClass())) {
                ((SearchExtractorRegistrationManager)ComponentAccessor.getComponent(SearchExtractorRegistrationManager.class)).register((EntitySearchExtractor)this.searchExtractorType.cast(extractor), this.entityType);
            }
        }

        @Override
        public void unregister(EntitySearchExtractor<?> extractor) {
            if (this.searchExtractorType.isAssignableFrom(extractor.getClass())) {
                ((SearchExtractorRegistrationManager)ComponentAccessor.getComponent(SearchExtractorRegistrationManager.class)).unregister((EntitySearchExtractor)this.searchExtractorType.cast(extractor), this.entityType);
            }
        }

        @Override
        public Class<E> getEntityType() {
            return this.entityType;
        }
    }

    static interface RegistrationStrategy<E> {
        public void register(EntitySearchExtractor<?> var1);

        public void unregister(EntitySearchExtractor<?> var1);

        public Class<E> getEntityType();
    }
}

