/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issueview;

import com.atlassian.jira.plugin.issueview.IssueViewFieldParams;
import java.util.Collections;
import java.util.Set;

public class IssueViewFieldParamsImpl
implements IssueViewFieldParams {
    private final boolean customViewRequested;
    private final Set<String> fieldIds;
    private final Set<String> orderableFieldIds;
    private final Set<String> customFieldIds;
    private final boolean allCustomFields;

    public IssueViewFieldParamsImpl(boolean customViewRequested, Set<String> fieldIds, Set<String> orderableFieldIds, Set<String> customFieldIds, boolean allCustomFields) {
        this.customViewRequested = customViewRequested;
        this.fieldIds = fieldIds;
        this.orderableFieldIds = Collections.unmodifiableSet(orderableFieldIds);
        this.customFieldIds = Collections.unmodifiableSet(customFieldIds);
        this.allCustomFields = allCustomFields;
    }

    public Set<String> getFieldIds() {
        return this.fieldIds;
    }

    public Set<String> getCustomFieldIds() {
        return this.customFieldIds;
    }

    public boolean isAllCustomFields() {
        return this.allCustomFields;
    }

    public Set<String> getOrderableFieldIds() {
        return this.orderableFieldIds;
    }

    public boolean isCustomViewRequested() {
        return this.customViewRequested;
    }

    public boolean isAnyFieldDefined() {
        return this.allCustomFields || this.fieldIds.size() > 0 || this.customFieldIds.size() > 0;
    }
}

