/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.issue.changehistory.UpdateHistoryAccessor;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.resolver.UserResolver;
import com.atlassian.jira.jql.util.DateRange;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.plugin.jql.function.AbstractJqlFunction;
import com.atlassian.jira.plugin.jql.function.event.UpdatedByUsageEvent;
import com.atlassian.jira.plugin.jql.function.event.UpdatedByValidationEvent;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timer;
import com.atlassian.util.profiling.Timers;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class UpdatedByFunction
extends AbstractJqlFunction {
    public static final String FUNCTION_ISSUES_UPDATED = "updatedBy";
    public static final String PROFILING_ID = "UpdatedByFunction.getValues";
    private static final Timer TIMER = Timers.timer((String)"UpdatedByFunction.getValues");
    private final UserResolver userResolver;
    private final UpdateHistoryAccessor updateHistoryAccessor;
    private final JqlDateSupport jqlDateSupport;
    private final EventPublisher eventPublisher;

    public UpdatedByFunction(UserResolver userResolver, UpdateHistoryAccessor updateHistoryAccessor, JqlDateSupport jqlDateSupport, EventPublisher eventPublisher) {
        this.userResolver = (UserResolver)Assertions.notNull((String)"userResolver", (Object)userResolver);
        this.updateHistoryAccessor = (UpdateHistoryAccessor)Assertions.notNull((String)"updateHistoryAccessor", (Object)updateHistoryAccessor);
        this.jqlDateSupport = (JqlDateSupport)Assertions.notNull((String)"jqlDateSupport", (Object)jqlDateSupport);
        this.eventPublisher = (EventPublisher)Assertions.notNull((String)"eventPublisher", (Object)eventPublisher);
    }

    @Nonnull
    public MessageSet validate(ApplicationUser searcher, FunctionOperand operand, TerminalClause terminalClause) {
        String dateToString;
        String dateFromString;
        MessageSetImpl messageSet = new MessageSetImpl();
        List args = operand.getArgs();
        if (searcher == null) {
            messageSet = new MessageSetImpl();
            messageSet.addErrorMessage(this.getI18n().getText("jira.jql.function.anonymous.disallowed", this.getFunctionName()));
            return messageSet;
        }
        if (args.isEmpty() || args.size() > 3) {
            messageSet.addErrorMessage(this.getI18n().getText("jira.jql.function.updated.by.invalid.argument.number", this.getFunctionName()));
            this.reportValidationError(UpdatedByValidationEvent.ValidationOutcome.PARAM_NO);
            return messageSet;
        }
        String userid = (String)args.get(0);
        if (!this.userResolver.nameExists(userid)) {
            messageSet.addErrorMessage(this.getI18n().getText("jira.jql.function.updated.by.no.such.user", this.getFunctionName()));
            this.reportValidationError(UpdatedByValidationEvent.ValidationOutcome.WRONG_USER);
        }
        if (args.size() > 1 && this.validateDate((MessageSet)messageSet, dateFromString = (String)args.get(1), "jira.jql.function.updated.by.invalid.date.from") && args.size() > 2 && this.validateDate((MessageSet)messageSet, dateToString = (String)args.get(2), "jira.jql.function.updated.by.invalid.date.to")) {
            Date dateFrom = this.jqlDateSupport.convertToDate(dateFromString);
            Date dateTo = this.jqlDateSupport.convertToDate(dateToString);
            if (dateTo.before(dateFrom)) {
                messageSet.addErrorMessage(this.getI18n().getText("jira.jql.function.updated.by.invalid.date.range", this.getFunctionName()));
                this.reportValidationError(UpdatedByValidationEvent.ValidationOutcome.DATE_ORDER);
            }
        }
        return messageSet;
    }

    private void reportValidationError(UpdatedByValidationEvent.ValidationOutcome outcome) {
        this.eventPublisher.publish((Object)new UpdatedByValidationEvent(outcome));
    }

    protected boolean validateDate(MessageSet messageSet, String dateString, String i18nKey) {
        if (dateString == null || dateString.length() == 0 || !this.jqlDateSupport.validate(dateString)) {
            messageSet.addErrorMessage(this.getI18n().getText(i18nKey, this.getFunctionName()));
            this.reportValidationError(UpdatedByValidationEvent.ValidationOutcome.DATE_FORMAT);
            return false;
        }
        return true;
    }

    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, FunctionOperand operand, TerminalClause terminalClause) {
        Assertions.notNull((String)"queryCreationContext", (Object)queryCreationContext);
        Assertions.notNull((String)"operand", (Object)operand);
        try (Ticker ignored = TIMER.start(new String[0]);){
            List args = operand.getArgs();
            List<String> userIds = this.getUserNames(args, 0);
            LinkedList<QueryLiteral> literals = new LinkedList<QueryLiteral>();
            Set<String> issueIds = Collections.emptySet();
            DateRange fromDate = null;
            DateRange toDate = null;
            if (!userIds.isEmpty()) {
                fromDate = this.getDateArgSafely(args, 1);
                toDate = this.getDateArgSafely(args, 2);
                issueIds = this.updateHistoryAccessor.searchForIssues(userIds, fromDate, toDate, queryCreationContext);
                literals.addAll(issueIds.stream().map(a -> new QueryLiteral((Operand)operand, Long.valueOf(Long.parseLong(a)))).collect(Collectors.toList()));
            }
            this.reportUsage(args, issueIds, fromDate, toDate);
            LinkedList<QueryLiteral> linkedList = literals;
            return linkedList;
        }
    }

    private void reportUsage(List<String> args, Set<String> issueIds, DateRange fromDate, DateRange toDate) {
        this.eventPublisher.publish((Object)new UpdatedByUsageEvent(args.size(), issueIds.size()));
    }

    private List<String> getUserNames(List<String> args, int index) {
        if (args != null && args.size() >= 1) {
            String userArg = args.get(index);
            return this.userResolver.getIdsFromName(userArg);
        }
        return Collections.emptyList();
    }

    private DateRange getDateArgSafely(List<String> args, int index) {
        DateRange dateRange = null;
        if (args.size() > index) {
            dateRange = this.jqlDateSupport.convertToDateRangeWithImpliedPrecision(args.get(index));
        }
        return dateRange;
    }

    public int getMinimumNumberOfExpectedArguments() {
        return 1;
    }

    public JiraDataType getDataType() {
        return JiraDataTypes.ISSUE;
    }

    public String getFunctionName() {
        return FUNCTION_ISSUES_UPDATED;
    }
}

