/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.navigation;

import com.atlassian.adapter.jackson.ObjectMapper;
import com.atlassian.jira.ajsmeta.GoogleSiteVerification;
import com.atlassian.jira.ajsmeta.HtmlMetadataManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutManager;
import com.atlassian.jira.plugin.navigation.FooterModuleDescriptor;
import com.atlassian.jira.plugin.navigation.PluggableFooter;
import com.atlassian.jira.plugin.navigation.TopNavigationModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorComparator;
import com.atlassian.jira.plugin.webfragment.DefaultWebFragmentContext;
import com.atlassian.jira.web.filters.accesslog.AccessLogImprinter;
import com.atlassian.jira.web.pagebuilder.DecoratablePage;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.jira.web.util.ProductVersionDataBeanProvider;
import com.atlassian.ozymandias.PluginPointVisitor;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.resource.ResourcePhase;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.io.Writer;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderFooterRendering {
    public static final String META_X_UA_COMPATIBLE = "meta.x.ua.compatible";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(HeaderFooterRendering.class);
    private final ApplicationProperties applicationProperties;
    private final PluginAccessor pluginAccessor;
    private final JiraPageBuilderService pageBuilderService;
    private final WebInterfaceManager webInterfaceManager;
    private final ProductVersionDataBeanProvider productVersionDataBeanProvider;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final GoogleSiteVerification googleSiteVerification;
    private final FeatureManager featureManager;

    public HeaderFooterRendering(ApplicationProperties applicationProperties, PluginAccessor pluginAccessor, JiraPageBuilderService pageBuilderService, WebInterfaceManager webInterfaceManager, ProductVersionDataBeanProvider productVersionDataBeanProvider, WebResourceUrlProvider webResourceUrlProvider, GoogleSiteVerification googleSiteVerification, FeatureManager featureManager) {
        this.applicationProperties = applicationProperties;
        this.pluginAccessor = pluginAccessor;
        this.pageBuilderService = pageBuilderService;
        this.webInterfaceManager = webInterfaceManager;
        this.productVersionDataBeanProvider = productVersionDataBeanProvider;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.googleSiteVerification = googleSiteVerification;
        this.featureManager = featureManager;
    }

    public void flushRemainingResources(JspWriter out, HttpServletRequest request) throws IOException {
        this.requireKeyboardShortcutsData(request);
        this.pageBuilderService.assembler().resources().requireContext(ResourcePhase.DEFER, "jira.webresources:resource-phase-checkpoint-hit");
        this.pageBuilderService.assembler().assembled().drainIncludedResources().writeHtmlTags((Writer)out, UrlMode.AUTO);
        out.flush();
    }

    private void requireKeyboardShortcutsData(HttpServletRequest request) {
        this.pageBuilderService.assembler().data().requireData("keyboardShortcutsUrl", writer -> writer.write(OBJECT_MAPPER.writeValueAsString((Object)this.getKeyboardShortCutScript(request))));
    }

    public void includeTopNavigation(final JspWriter out, final HttpServletRequest httpServletRequest, Page page) {
        SafePluginPointAccess.to().runnable(new Runnable(){

            @Override
            public void run() {
                HeaderFooterRendering.this.includeTopNavigation(out, httpServletRequest, HeaderFooterRendering.this.getWebFragmentContext("atl.header"));
            }
        });
    }

    public void includeTopNavigation(JspWriter out, HttpServletRequest httpServletRequest) {
        SafePluginPointAccess.to().runnable(() -> this.includeTopNavigation(out, httpServletRequest, this.getWebFragmentContext("atl.header")));
    }

    public void includeFooters(JspWriter out, HttpServletRequest httpServletRequest) {
        SafePluginPointAccess.to().runnable(() -> {
            try {
                this.includeFootersOnPage(out, httpServletRequest);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void includeAccessLogImprints(JspWriter out, HttpServletRequest httpServletRequest) {
        SafePluginPointAccess.to().runnable(() -> {
            try {
                this.includeAccessLogImprintsOnPage(out, httpServletRequest);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void includeWebPanels(JspWriter out, String location) {
        SafePluginPointAccess.to().runnable(() -> this.includeWebPanelsOnPage(out, location));
    }

    public String getPageTitle(Page originalPage) {
        return this.getPageTitle(originalPage.getTitle());
    }

    public String getPageTitle(DecoratablePage.ParsedHead parsedHead) {
        return this.getPageTitle(parsedHead.getTitle());
    }

    public String getXUACompatible(Page originalPage) {
        String xUaCompatible = originalPage.getProperty(META_X_UA_COMPATIBLE);
        if (xUaCompatible == null) {
            xUaCompatible = "IE=Edge";
        }
        return xUaCompatible;
    }

    public String getRelativeResourcePrefix() {
        String result = (String)SafePluginPointAccess.call((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return HeaderFooterRendering.this.webResourceUrlProvider.getStaticResourcePrefix(com.atlassian.plugin.webresource.UrlMode.RELATIVE);
            }
        }).getOrNull();
        return result != null ? result : "";
    }

    public void includeVersionMetaTags(final JspWriter out) {
        SafePluginPointAccess.to().runnable(new Runnable(){

            @Override
            public void run() {
                try {
                    out.write(HeaderFooterRendering.this.productVersionDataBeanProvider.get().getMetaTags());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void requireCommonMetadata() {
        HtmlMetadataManager htmlMetadataManager = (HtmlMetadataManager)ComponentAccessor.getComponent(HtmlMetadataManager.class);
        if (htmlMetadataManager != null) {
            htmlMetadataManager.requireCommonMetadata();
        }
    }

    public void includeMetadata(JspWriter out) throws IOException {
        HtmlMetadataManager htmlMetadataManager = (HtmlMetadataManager)ComponentAccessor.getComponent(HtmlMetadataManager.class);
        if (htmlMetadataManager != null) {
            htmlMetadataManager.includeMetadata((Writer)out);
        }
    }

    public void includeGoogleSiteVerification(JspWriter out) throws IOException {
        if (this.googleSiteVerification.isAvailable()) {
            this.googleSiteVerification.writeHtml((Writer)out);
        }
    }

    public String getKeyboardShortCutScript(final HttpServletRequest httpServletRequest) {
        final KeyboardShortcutManager keyboardShortcutManager = (KeyboardShortcutManager)ComponentAccessor.getComponent(KeyboardShortcutManager.class);
        if (keyboardShortcutManager != null) {
            String result = (String)SafePluginPointAccess.call((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return httpServletRequest.getContextPath() + keyboardShortcutManager.includeShortcuts();
                }
            }).getOrNull();
            return result;
        }
        return "";
    }

    protected void includeTopNavigation(JspWriter out, HttpServletRequest httpServletRequest, Map<String, Object> webFragmentContext) {
        ArrayList topNavPlugins = Lists.newArrayList((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(TopNavigationModuleDescriptor.class));
        Collections.sort(topNavPlugins, ModuleDescriptorComparator.COMPARATOR);
        SafePluginPointAccess.to().descriptors((Iterable)topNavPlugins, (topNavigation, pluggableTopNavigation) -> {
            try {
                if (topNavigation.getCondition() == null || !topNavigation.getCondition().shouldDisplay(webFragmentContext)) {
                    return;
                }
                boolean themeSwitcherEnabled = this.featureManager.getDarkFeatures().isFeatureEnabled("com.atlassian.jira.theme.switcher.enabled");
                if (themeSwitcherEnabled) {
                    this.pageBuilderService.assembler().resources().requireContext(ResourcePhase.DEFER, "themeSwitcher");
                }
                out.write(pluggableTopNavigation.getHtml(httpServletRequest));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void includeFootersOnPage(final JspWriter out, final HttpServletRequest httpServletRequest) throws IOException {
        ArrayList footerPlugins = Lists.newArrayList((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(FooterModuleDescriptor.class));
        Collections.sort(footerPlugins, ModuleDescriptorComparator.COMPARATOR);
        SafePluginPointAccess.to().descriptors((Iterable)footerPlugins, (PluginPointVisitor)new PluginPointVisitor<FooterModuleDescriptor, PluggableFooter>(){

            public void visit(FooterModuleDescriptor footerModuleDescriptor, PluggableFooter pluggableFooter) {
                try {
                    out.write(pluggableFooter.getFullFooterHtml(httpServletRequest));
                }
                catch (IOException e) {
                    log.error(String.format("Unable to include web panel in context '%s' from class '%s' because of '%s'", footerModuleDescriptor.getCompleteKey(), pluggableFooter.getClass().getCanonicalName(), e.getMessage()), (Throwable)e);
                }
            }
        });
    }

    private void includeAccessLogImprintsOnPage(JspWriter out, HttpServletRequest httpServletRequest) throws IOException {
        AccessLogImprinter imprinter = new AccessLogImprinter(httpServletRequest, Clock.systemDefaultZone());
        out.print(imprinter.imprintHiddenHtml());
        out.print(imprinter.imprintHTMLComment());
    }

    private void includeWebPanelsOnPage(JspWriter out, String location) {
        Map<String, Object> context = this.getWebFragmentContext(location);
        List displayableWebPanels = this.webInterfaceManager.getDisplayableWebPanels(location, context);
        for (WebPanel webPanel : displayableWebPanels) {
            this.getWebPanelSafely(out, location, context, webPanel);
        }
    }

    private void getWebPanelSafely(JspWriter out, String location, Map<String, Object> context, WebPanel webPanel) {
        try {
            webPanel.writeHtml((Writer)out, context);
        }
        catch (IOException | LinkageError | RuntimeException e) {
            log.error("Unable to include web panel in context '{}' from class '{}' because of '{}'", new Object[]{location, webPanel.getClass().getCanonicalName(), e.getMessage()});
        }
    }

    private String getPageTitle(String pageTitle) {
        String appTitle = TextUtils.htmlEncode((String)this.applicationProperties.getDefaultBackedString("jira.title"));
        String actualTitle = pageTitle == null ? appTitle : (pageTitle.equals(appTitle) ? pageTitle : pageTitle + " - " + appTitle);
        return actualTitle;
    }

    @VisibleForTesting
    Map<String, Object> getWebFragmentContext(String location) {
        return DefaultWebFragmentContext.get((String)location);
    }
}

