/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.permission;

import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.permission.GlobalPermissionModuleDescriptor;
import com.atlassian.jira.plugin.permission.GlobalPermissionParseException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import java.text.MessageFormat;
import javax.annotation.Nonnull;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class GlobalPermissionModuleDescriptorImpl
extends AbstractJiraModuleDescriptor<Void>
implements GlobalPermissionModuleDescriptor {
    private static final String GLOBAL_PERMISSION_ROOT = "global-permission";
    private static final String GLOBAL_PERMISSION_I18N_DESCRIPTION = "i18n-description-key";
    private static final String GLOBAL_PERMISSION_ANONYMOUS_ALLOWED = "anonymous-allowed";
    private String descriptionI18nKey;
    private boolean anonymousAllowed;

    public GlobalPermissionModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
    }

    @Override
    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        try {
            if (!GLOBAL_PERMISSION_ROOT.equals(element.getName())) {
                throw new GlobalPermissionParseException(MessageFormat.format("Root element for configuration should be {0}", GLOBAL_PERMISSION_ROOT));
            }
            this.descriptionI18nKey = this.getRequiredAttribute(element, GLOBAL_PERMISSION_ROOT, GLOBAL_PERMISSION_I18N_DESCRIPTION);
            this.anonymousAllowed = this.getOptionalBooleanAttribute(element, GLOBAL_PERMISSION_ANONYMOUS_ALLOWED, true);
        }
        catch (GlobalPermissionParseException e) {
            throw new PluginParseException("Cannot parse global permission plugin descriptor", (Throwable)e);
        }
    }

    private String getRequiredAttribute(Element element, String elementName, String attributeName) throws GlobalPermissionParseException {
        Attribute entityKeyAttribute = element.attribute(attributeName);
        if (entityKeyAttribute == null) {
            throw new GlobalPermissionParseException(MessageFormat.format("Element {0} must have attribute {1} defined", elementName, attributeName));
        }
        return entityKeyAttribute.getValue();
    }

    private boolean getOptionalBooleanAttribute(Element element, String attributeName, boolean defaultValue) throws GlobalPermissionParseException {
        String value;
        Attribute entityKeyAttribute = element.attribute(attributeName);
        if (entityKeyAttribute != null && ("true".equals(value = entityKeyAttribute.getValue()) || "false".equals(value))) {
            return Boolean.valueOf(value);
        }
        return defaultValue;
    }

    @Override
    public String getDescriptionI18nKey() {
        return this.descriptionI18nKey;
    }

    @Override
    public boolean isAnonymousAllowed() {
        return this.anonymousAllowed;
    }
}

