/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.startup;

import com.atlassian.jira.plugin.PluginVersion;
import com.atlassian.jira.plugin.startup.PluginVersionsChangeReport;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PluginVersionsChangeAnalyser {
    public PluginVersionsChangeReport buildReport(Collection<PluginVersion> storedPluginVersions, Collection<PluginVersion> installedPluginVersions) {
        Assertions.notNull(storedPluginVersions);
        Assertions.notNull(installedPluginVersions);
        PluginVersionsChangeReport.Builder reportBuilder = PluginVersionsChangeReport.builder();
        Map storedPluginVersionsByKey = storedPluginVersions.stream().collect(Collectors.toMap(PluginVersion::getKey, Function.identity()));
        Map installedPluginVersionsByKey = installedPluginVersions.stream().collect(Collectors.toMap(PluginVersion::getKey, Function.identity()));
        Sets.union(storedPluginVersionsByKey.keySet(), installedPluginVersionsByKey.keySet()).stream().map(key -> new PluginVersionsChangeReport.PluginVersionChangeEntry((PluginVersion)storedPluginVersionsByKey.get(key), (PluginVersion)installedPluginVersionsByKey.get(key))).forEach(reportBuilder::add);
        return reportBuilder.build();
    }
}

