/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.util;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.elements.ResourceDescriptor;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class ModuleDescriptorPredicates {
    private ModuleDescriptorPredicates() {
    }

    public static Predicate<Plugin> isPluginWithModuleDescriptor(@Nonnull Class<? extends ModuleDescriptor> targetModuleClass) {
        return plugin -> plugin.getModuleDescriptors().stream().map(Object::getClass).anyMatch(targetModuleClass::isAssignableFrom);
    }

    public static Predicate<Plugin> isPluginWithResourceType(@Nonnull String pluginResourceType) {
        return plugin -> {
            Stream resourceDescriptors = Stream.concat(plugin.getResourceDescriptors().stream(), plugin.getModuleDescriptors().stream().flatMap(module -> module.getResourceDescriptors().stream()));
            return resourceDescriptors.map(ResourceDescriptor::getType).anyMatch(pluginResourceType::equals);
        };
    }
}

