/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.plugin.webfragment.SimpleLinkFactory;
import com.atlassian.jira.plugin.webfragment.SimpleLinkFactoryModuleDescriptors;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.descriptors.SimpleLinkFactoryModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkImpl;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSectionImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.WebSection;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSimpleLinkManager
implements SimpleLinkManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultSimpleLinkManager.class);
    private final SimpleLinkFactoryModuleDescriptors simpleLinkFactoryModuleDescriptors;
    private final JiraAuthenticationContext authenticationContext;
    private final JiraProperties jiraProperties;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final DynamicWebInterfaceManager webInterfaceManager;

    public DefaultSimpleLinkManager(DynamicWebInterfaceManager webInterfaceManager, SimpleLinkFactoryModuleDescriptors simpleLinkFactoryModuleDescriptors, JiraAuthenticationContext authenticationContext, JiraProperties jiraProperties, WebResourceUrlProvider webResourceUrlProvider, VelocityRequestContextFactory velocityRequestContextFactory) {
        this.webInterfaceManager = webInterfaceManager;
        this.simpleLinkFactoryModuleDescriptors = simpleLinkFactoryModuleDescriptors;
        this.authenticationContext = authenticationContext;
        this.jiraProperties = jiraProperties;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
    }

    public boolean shouldLocationBeLazy(@Nonnull String location, ApplicationUser remoteUser, @Nonnull JiraHelper jiraHelper) {
        Iterable sections = (Iterable)SafePluginPointAccess.call(() -> this.webInterfaceManager.getDisplayableWebSections(location, this.makeContext(remoteUser, jiraHelper))).getOrElse(Collections.emptyList());
        Iterable<SimpleLinkFactoryModuleDescriptor> linkFactories = this.simpleLinkFactoryModuleDescriptors.get();
        for (WebSection section : sections) {
            if (!Boolean.parseBoolean((String)section.getParams().get("lazy")) && !Iterables.any(linkFactories, (Predicate)new SectionPredicate(location, section))) continue;
            return true;
        }
        return false;
    }

    public boolean shouldSectionBeLazy(String section) {
        for (SimpleLinkFactoryModuleDescriptor linkFactory : this.simpleLinkFactoryModuleDescriptors.get()) {
            if (!section.equals(linkFactory.getSection()) || !linkFactory.shouldBeLazy()) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public List<SimpleLink> getLinksForSection(@Nonnull String section, ApplicationUser remoteUser, @Nonnull JiraHelper jiraHelper) {
        return this.getLinksForSection(section, remoteUser, jiraHelper, false);
    }

    @Nonnull
    public List<SimpleLink> getLinksForSection(@Nonnull String section, ApplicationUser remoteUser, @Nonnull JiraHelper jiraHelper, boolean addIconCachingPrefix) {
        return this.getLinks(section, this.webInterfaceManager.getDisplayableWebItems(section, this.makeContext(remoteUser, jiraHelper)), remoteUser, jiraHelper, addIconCachingPrefix);
    }

    @Nonnull
    public List<SimpleLink> getLinksForSectionIgnoreConditions(@Nonnull String section, ApplicationUser remoteUser, @Nonnull JiraHelper jiraHelper) {
        return this.getLinks(section, this.webInterfaceManager.getWebItems(section, this.makeContext(remoteUser, jiraHelper)), remoteUser, jiraHelper, false);
    }

    private List<SimpleLink> getLinks(String section, Iterable<WebItem> items, ApplicationUser user, JiraHelper jiraHelper, boolean addIconCachingPrefix) {
        WebItem item;
        ArrayList<SimpleLink> returnLinks = new ArrayList<SimpleLink>();
        ArrayList matchingFactories = new ArrayList();
        ArrayList descriptorList = Lists.newArrayList(this.simpleLinkFactoryModuleDescriptors.get());
        SafePluginPointAccess.to().descriptors((Iterable)descriptorList, (descriptor, factory) -> {
            if (section.equals(descriptor.getSection())) {
                matchingFactories.add(descriptor);
            }
        });
        Iterator factoryIterator = matchingFactories.iterator();
        Iterator<WebItem> itemIterator = items.iterator();
        SimpleLinkFactoryModuleDescriptor factory2 = factoryIterator.hasNext() ? (SimpleLinkFactoryModuleDescriptor)factoryIterator.next() : null;
        WebItem webItem = item = itemIterator.hasNext() ? itemIterator.next() : null;
        while (factory2 != null || item != null) {
            if (factory2 != null && item != null) {
                if (factory2.getWeight() < item.getWeight()) {
                    this.addLinksFromFactory(user, jiraHelper, returnLinks, factory2);
                    factory2 = factoryIterator.hasNext() ? (SimpleLinkFactoryModuleDescriptor)factoryIterator.next() : null;
                    continue;
                }
                this.addLinkFromWebItem(item, addIconCachingPrefix, returnLinks);
                item = itemIterator.hasNext() ? itemIterator.next() : null;
                continue;
            }
            if (factory2 == null) {
                this.addLinkFromWebItem(item, addIconCachingPrefix, returnLinks);
                item = itemIterator.hasNext() ? itemIterator.next() : null;
                continue;
            }
            this.addLinksFromFactory(user, jiraHelper, returnLinks, factory2);
            factory2 = factoryIterator.hasNext() ? (SimpleLinkFactoryModuleDescriptor)factoryIterator.next() : null;
        }
        return returnLinks;
    }

    private void addLinkFromWebItem(WebItem item, boolean addIconCachingPrefix, List<SimpleLink> links) {
        SimpleLink link = this.convertWebItemToSimpleLink(item, addIconCachingPrefix);
        if (link != null) {
            links.add(link);
        }
    }

    private void addLinksFromFactory(ApplicationUser user, JiraHelper jiraHelper, List<SimpleLink> links, SimpleLinkFactoryModuleDescriptor factory) {
        SafePluginPointAccess.call(() -> {
            SimpleLinkFactory factoryModule = (SimpleLinkFactory)factory.getModule();
            if (factoryModule != null) {
                links.addAll(factoryModule.getLinks(user, jiraHelper.getContextParams()));
            }
            return null;
        });
    }

    @Nullable
    private SimpleLink convertWebItemToSimpleLink(WebItem item, boolean addIconCachingPrefix) {
        String iconUrl = (String)item.getParams().get("iconUrl");
        if (StringUtils.isNotBlank((CharSequence)iconUrl) && this.isRelativeUrl(iconUrl)) {
            if (addIconCachingPrefix) {
                String staticResourcePrefix = this.webResourceUrlProvider.getStaticResourcePrefix(UrlMode.RELATIVE);
                iconUrl = staticResourcePrefix + iconUrl;
            } else {
                String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
                if (!StringUtils.startsWith((CharSequence)iconUrl, (CharSequence)baseUrl)) {
                    iconUrl = baseUrl + iconUrl;
                }
            }
        }
        Option id = Option.option((Object)item.getId());
        try {
            return new SimpleLinkImpl((String)id.getOrElse((Object)item.getCompleteKey()), item.getLabel(), item.getTitle(), iconUrl, item.getStyleClass(), item.getParams(), item.getUrl(), item.getAccessKey(), Integer.valueOf(item.getWeight()));
        }
        catch (Exception exception) {
            if (this.jiraProperties.isDevMode()) {
                log.error("Failed to render a declared web-item=<{}>", (Object)item, (Object)exception);
            }
            return null;
        }
    }

    @Nonnull
    public List<SimpleLinkSection> getSectionsForLocation(@Nonnull String location, ApplicationUser remoteUser, @Nonnull JiraHelper jiraHelper) {
        Iterable sections = (Iterable)SafePluginPointAccess.call(() -> this.webInterfaceManager.getDisplayableWebSections(location, this.makeContext(remoteUser, jiraHelper))).getOrElse(Collections.emptyList());
        ArrayList<SimpleLinkSection> returnSections = new ArrayList<SimpleLinkSection>(Iterables.size((Iterable)sections));
        for (WebSection section : sections) {
            returnSections.add(this.convertWebSectionToSimpleLinkSection(section));
        }
        return returnSections;
    }

    @Nonnull
    public List<SimpleLinkSection> getNotEmptySectionsForLocation(@Nonnull String location, ApplicationUser remoteUser, @Nonnull JiraHelper jiraHelper) {
        List<SimpleLinkSection> allSections = this.getSectionsForLocation(location, remoteUser, jiraHelper);
        ArrayList<SimpleLinkSection> notEmptySections = new ArrayList<SimpleLinkSection>(allSections.size());
        for (SimpleLinkSection section : allSections) {
            List<SimpleLink> directLinks = this.getLinksForSection(section.getId(), remoteUser, jiraHelper);
            if (directLinks.size() > 0) {
                notEmptySections.add(section);
                continue;
            }
            List<SimpleLink> links = this.getLinksForSection(location + "/" + section.getId(), remoteUser, jiraHelper);
            if (links.size() > 0) {
                notEmptySections.add(section);
                continue;
            }
            List<SimpleLinkSection> subSections = this.getNotEmptySectionsForLocation(section.getId(), remoteUser, jiraHelper);
            if (subSections.size() <= 0) continue;
            notEmptySections.add(section);
        }
        return notEmptySections;
    }

    private SimpleLinkSection convertWebSectionToSimpleLinkSection(WebSection section) {
        return new SimpleLinkSectionImpl(section.getId(), section.getLabel(), section.getTitle(), null, section.getStyleClass(), section.getParams(), Integer.valueOf(section.getWeight()));
    }

    public SimpleLinkSection getSectionForURL(@Nonnull String topLevelSection, @Nonnull String URL2, ApplicationUser remoteUser, JiraHelper jiraHelper) {
        return this.findWebSectionForURL(topLevelSection, URL2, remoteUser, jiraHelper);
    }

    private SimpleLinkSection findWebSectionForURL(String currentLocation, String targetURL, ApplicationUser remoteUser, JiraHelper jiraHelper) {
        List<SimpleLinkSection> sections = this.getSectionsForLocation(currentLocation, remoteUser, jiraHelper);
        SimpleLinkSection sectionForURL = null;
        block0: for (SimpleLinkSection section : sections) {
            String subSection = currentLocation + "/" + section.getId();
            List<SimpleLink> links = this.getLinksForSection(subSection, remoteUser, jiraHelper);
            for (SimpleLink link : links) {
                if (!targetURL.endsWith(JiraUrl.extractActionFromURL((String)link.getUrl()))) continue;
                sectionForURL = new SimpleLinkSectionImpl(subSection, (SimpleLinkSectionImpl)section);
                break block0;
            }
            sectionForURL = this.findWebSectionForURL(section.getId(), targetURL, remoteUser, jiraHelper);
            if (sectionForURL == null) continue;
            break;
        }
        return sectionForURL;
    }

    private boolean isRelativeUrl(String url) {
        try {
            return !new URI(url).isAbsolute();
        }
        catch (URISyntaxException e) {
            return true;
        }
    }

    private Map<String, Object> makeContext(ApplicationUser remoteUser, JiraHelper jiraHelper) {
        Map params = jiraHelper.getContextParams();
        params.put("user", remoteUser);
        params.put("helper", jiraHelper);
        params.put("i18n", this.authenticationContext.getI18nHelper());
        return params;
    }

    private static class SectionPredicate
    implements Predicate<SimpleLinkFactoryModuleDescriptor> {
        private final String location;
        private final String key;

        private SectionPredicate(String location, WebSection webSection) {
            this.location = location;
            this.key = webSection.getId();
        }

        public boolean apply(SimpleLinkFactoryModuleDescriptor linkFactory) {
            return linkFactory.getSection().equals(this.location + "/" + this.key) && linkFactory.shouldBeLazy();
        }
    }
}

