/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.dashboard.DashboardUtil;
import com.atlassian.jira.plugin.webfragment.JiraWebContext;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;

public abstract class AbstractDashboardCondition
implements Condition {
    public static final String CONTEXT_KEY_DASHBOARD_ID = "dashboardId";

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Long dashboardId = DashboardUtil.toLong((DashboardId)((DashboardId)context.get(CONTEXT_KEY_DASHBOARD_ID)));
        if (dashboardId == null) {
            return false;
        }
        ApplicationUser appUser = this.getApplicationUser(context);
        if (appUser == null) {
            return false;
        }
        PortalPage defaultPortalPage = this.getPortalPageService().getSystemDefaultPortalPage();
        if (dashboardId.equals(defaultPortalPage.getId())) {
            return false;
        }
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(appUser);
        PortalPage portalPage = this.getPortalPageService().getPortalPage((JiraServiceContext)jiraServiceContext, dashboardId);
        return this.shouldDisplay(jiraServiceContext, portalPage);
    }

    private ApplicationUser getApplicationUser(Map<String, Object> context) {
        return JiraWebContext.from(context).getUser().orElse(null);
    }

    PortalPageService getPortalPageService() {
        return (PortalPageService)ComponentAccessor.getComponentOfType(PortalPageService.class);
    }

    abstract boolean shouldDisplay(JiraServiceContextImpl var1, PortalPage var2);
}

