/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractWebCondition;
import com.atlassian.jira.plugin.webfragment.conditions.UserIsAdminCondition;
import com.atlassian.jira.plugin.webfragment.conditions.cache.ConditionCacheKey;
import com.atlassian.jira.plugin.webfragment.conditions.cache.ConditionCacheKeys;
import com.atlassian.jira.plugin.webfragment.conditions.cache.RequestCachingConditionHelper;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Map;

public class CanAdministerProjectCondition
extends AbstractWebCondition {
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final UserIsAdminCondition isAdminCondition;

    public CanAdministerProjectCondition(GlobalPermissionManager globalPermissionManager, PermissionManager permissionManager, ProjectManager projectManager) {
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
        this.isAdminCondition = new UserIsAdminCondition(globalPermissionManager);
    }

    public void init(Map<String, String> params) {
    }

    public boolean shouldDisplay(ApplicationUser user, JiraHelper jiraHelper) {
        Project project = this.getProject(jiraHelper.getContextParams());
        if (project == null) {
            return false;
        }
        ConditionCacheKey cacheKey = ConditionCacheKeys.permission((ProjectPermissionKey)ProjectPermissions.ADMINISTER_PROJECTS, (ApplicationUser)user, (Object[])new Object[]{project.getKey()});
        return this.isAdminCondition.shouldDisplay(user, jiraHelper) || RequestCachingConditionHelper.cacheConditionResultInRequest((ConditionCacheKey)cacheKey, () -> this.hasPermission(user, project));
    }

    private boolean hasPermission(ApplicationUser user, Project project) {
        try {
            return this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, user);
        }
        catch (Exception e) {
            return false;
        }
    }

    private Project getProject(Map<String, Object> context) {
        JiraHelper helper;
        if (context.containsKey("project")) {
            return (Project)context.get("project");
        }
        if (context.containsKey("issue")) {
            return ((Issue)context.get("issue")).getProjectObject();
        }
        if (context.containsKey("helper") && (helper = (JiraHelper)context.get("helper")).getProjectObject() != null) {
            return helper.getProjectObject();
        }
        if (context.containsKey("version")) {
            return ((Version)context.get("version")).getProjectObject();
        }
        if (context.containsKey("component")) {
            Long projectId = ((ProjectComponent)context.get("component")).getProjectId();
            return this.projectManager.getProjectObj(projectId);
        }
        return null;
    }
}

