/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractFixedPermissionCondition;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import java.util.List;
import java.util.Map;

public class UserCanBrowseArchiveCondition
extends AbstractFixedPermissionCondition {
    private final PermissionManager permissionManager;
    private final ProjectService projectService;

    public UserCanBrowseArchiveCondition(GlobalPermissionManager globalPermissionManager, PermissionManager permissionManager, ProjectService projectService) {
        super(globalPermissionManager, GlobalPermissionKey.of((String)"GLOBAL_BROWSE_ARCHIVE"));
        this.permissionManager = permissionManager;
        this.projectService = projectService;
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        ApplicationUser appUser = this.getApplicationUser(context);
        return super.shouldDisplay(context) || ((List)this.projectService.getAllProjectsForAction(appUser, ProjectAction.VIEW_ARCHIVED_PROJECT).get()).stream().anyMatch(project -> this.permissionManager.hasPermission(ProjectPermissions.BROWSE_ARCHIVE, project, appUser));
    }
}

