/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.descriptors;

import com.atlassian.jira.plugin.webfragment.model.JiraWebLabel;
import com.atlassian.jira.plugin.webfragment.model.JiraWebParam;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.web.descriptors.AbstractWebFragmentModuleDescriptor;
import com.atlassian.plugin.web.descriptors.DefaultAbstractWebFragmentModuleDescriptor;
import com.atlassian.plugin.web.model.WebLabel;
import com.atlassian.plugin.web.model.WebParam;

public abstract class JiraAbstractWebFragmentModuleDescriptor
extends DefaultAbstractWebFragmentModuleDescriptor<Void> {
    protected final JiraAuthenticationContext authenticationContext;

    public JiraAbstractWebFragmentModuleDescriptor(JiraAuthenticationContext authenticationContext, AbstractWebFragmentModuleDescriptor<Void> abstractDescriptor) {
        super(abstractDescriptor);
        this.authenticationContext = authenticationContext;
    }

    public String getDescription() {
        String key = this.getDescriptionKey();
        if (key != null) {
            return this.getI18nBean().getText(key);
        }
        return super.getDescription();
    }

    public String getName() {
        if (this.getI18nNameKey() != null) {
            return this.getI18nBean().getText(this.getI18nNameKey());
        }
        return super.getName();
    }

    public WebLabel getLabel() {
        WebLabel label = this.getDecoratedDescriptor().getWebLabel();
        if (label != null) {
            return new JiraWebLabel(label, this.authenticationContext);
        }
        return null;
    }

    public WebLabel getTooltip() {
        WebLabel tooltip = this.getDecoratedDescriptor().getTooltip();
        if (tooltip != null) {
            return new JiraWebLabel(tooltip, this.authenticationContext);
        }
        return null;
    }

    public WebParam getWebParams() {
        WebParam webParams = this.getDecoratedDescriptor().getWebParams();
        if (webParams != null) {
            return new JiraWebParam(webParams);
        }
        return null;
    }

    public I18nHelper getI18nBean() {
        return this.authenticationContext.getI18nHelper();
    }
}

