/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.workflow;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.plugin.workflow.AbstractWorkflowPluginFactory;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowFireIssueEventFunctionPluginFactory
extends AbstractWorkflowPluginFactory
implements WorkflowPluginFunctionFactory {
    private static final Logger log = LoggerFactory.getLogger(WorkflowFireIssueEventFunctionPluginFactory.class);
    private static final String EVENT_TYPE = "eventType";
    private static final String EVENT_TYPES = "eventTypes";
    private static final String EVENT_TYPE_ID = "eventTypeId";
    private final EventTypeManager eventTypeManager;

    public WorkflowFireIssueEventFunctionPluginFactory(EventTypeManager eventTypeManager) {
        this.eventTypeManager = eventTypeManager;
    }

    protected void getVelocityParamsForInput(Map velocityParams) {
        velocityParams.put(EVENT_TYPES, this.getEventTypes());
    }

    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        EventType eventType = this.eventTypeManager.getEventType(this.getEventTypeId(descriptor));
        velocityParams.put(EVENT_TYPE_ID, eventType.getId());
    }

    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        EventType eventType = (EventType)this.getEventTypes().get(this.getEventTypeId(descriptor));
        velocityParams.put(EVENT_TYPE, eventType);
    }

    public Map getDescriptorParams(Map conditionParams) {
        if (conditionParams != null && conditionParams.containsKey(EVENT_TYPE_ID)) {
            return EasyMap.build((Object)EVENT_TYPE_ID, (Object)this.extractSingleParam(conditionParams, EVENT_TYPE_ID));
        }
        return EasyMap.build((Object)EVENT_TYPE_ID, (Object)EventType.ISSUE_GENERICEVENT_ID.toString());
    }

    private Map getEventTypes() {
        return this.eventTypeManager.getEventTypesMap();
    }

    private Long getEventTypeId(AbstractDescriptor descriptor) {
        if (!(descriptor instanceof FunctionDescriptor)) {
            throw new IllegalArgumentException("Descriptor must be a FunctionDescriptor.");
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor;
        try {
            return new Long((String)functionDescriptor.getArgs().get(EVENT_TYPE_ID));
        }
        catch (NumberFormatException e) {
            log.error("Error while converting '" + functionDescriptor.getArgs().get(EVENT_TYPE_ID) + "' to a number.", (Throwable)e);
            return null;
        }
    }
}

