/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.portal;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.gadgets.Vote;
import com.atlassian.gadgets.plugins.PluginGadgetSpec;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.dashboard.permission.GadgetPermissionManager;
import com.atlassian.jira.event.SharedEntityUpdatedMetricsEvent;
import com.atlassian.jira.event.sharedentity.SharedEntityCreatedEvent;
import com.atlassian.jira.event.sharedentity.SharedEntityDeletedEvent;
import com.atlassian.jira.event.sharedentity.SharedEntityUpdatedEvent;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortalPageManager;
import com.atlassian.jira.portal.PortalPageStore;
import com.atlassian.jira.portal.PortletConfiguration;
import com.atlassian.jira.portal.PortletConfigurationManager;
import com.atlassian.jira.portal.events.DashboardCreated;
import com.atlassian.jira.portal.events.DashboardDeleted;
import com.atlassian.jira.portal.events.DashboardUpdated;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.sharing.index.SharedEntityIndexer;
import com.atlassian.jira.sharing.rights.ShareRight;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.sharing.search.SharedEntitySearchResult;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Resolver;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.collect.Transformed;
import com.atlassian.jira.util.dbc.Assertions;
import io.atlassian.fugue.Option;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultPortalPageManager
implements PortalPageManager {
    private final ShareManager shareManager;
    private final PortalPageStore portalPageStore;
    private final PortletConfigurationManager portletConfigurationManager;
    private final SharedEntityIndexer indexer;
    private GadgetPermissionManager gadgetPermissionManager;
    private final EventPublisher eventPublisher;
    private final JiraAuthenticationContext authenticationContext;
    private final Resolver<PortalPage, PortalPage> permissionResolver = portalPage -> this.setRelatedState((PortalPage)portalPage);

    public DefaultPortalPageManager(ShareManager shareManager, PortalPageStore portalPageStore, PortletConfigurationManager portletConfigurationManager, SharedEntityIndexer indexer, EventPublisher eventPublisher, JiraAuthenticationContext authenticationContext) {
        this.shareManager = shareManager;
        this.portalPageStore = portalPageStore;
        this.portletConfigurationManager = portletConfigurationManager;
        this.indexer = indexer;
        this.eventPublisher = eventPublisher;
        this.authenticationContext = authenticationContext;
    }

    public SharedEntity.TypeDescriptor<PortalPage> getType() {
        return PortalPage.ENTITY_TYPE;
    }

    public void adjustFavouriteCount(SharedEntity entity, int adjustmentValue) {
        Assertions.notNull((String)"entity", (Object)entity);
        Assertions.equals((String)"PortalPage type", (Object)PortalPage.ENTITY_TYPE, (Object)entity.getEntityType());
        PortalPage portalPage = this.portalPageStore.adjustFavouriteCount(entity, adjustmentValue);
        this.indexer.index((SharedEntity)this.setRelatedState(portalPage)).await();
    }

    public PortalPage getSharedEntity(Long entityId) {
        Assertions.notNull((String)"entityId", (Object)entityId);
        return this.getPortalPageById(entityId);
    }

    public PortalPage getSharedEntity(ApplicationUser user, Long entityId) {
        Assertions.notNull((String)"entityId", (Object)entityId);
        return this.getPortalPage(user, entityId);
    }

    public boolean hasPermissionToUse(ApplicationUser user, PortalPage portalPage) {
        Assertions.notNull((String)"portalPage", (Object)portalPage);
        return portalPage.isSystemDefaultPortalPage() || this.isSharedWith(portalPage, user);
    }

    public EnclosedIterable<PortalPage> getAll() {
        return Transformed.enclosedIterable(this.portalPageStore.getAll(), this.permissionResolver);
    }

    public EnclosedIterable<SharedEntity> getAllIndexableSharedEntities() {
        EnclosedIterable<PortalPage> all = this.getAll();
        return all;
    }

    public EnclosedIterable<PortalPage> get(SharedEntityAccessor.RetrievalDescriptor descriptor) {
        return Transformed.enclosedIterable(this.portalPageStore.get(descriptor), this.permissionResolver);
    }

    public EnclosedIterable<PortalPage> get(ApplicationUser user, SharedEntityAccessor.RetrievalDescriptor ids) {
        return this.get(ids);
    }

    public Collection<PortalPage> getAllOwnedPortalPages(ApplicationUser owner) {
        Assertions.notNull((String)"owner", (Object)owner);
        Assertions.notNull((String)"owner.name", (Object)owner.getName());
        Collection<PortalPage> portalPages = this.portalPageStore.getAllOwnedPortalPages(owner);
        if (portalPages == null) {
            return Collections.emptyList();
        }
        return this.setRelatedState(portalPages);
    }

    public PortalPage getPortalPageByName(ApplicationUser owner, String pageName) {
        Assertions.notNull((String)"owner", (Object)owner);
        Assertions.notNull((String)"owner,name", (Object)owner.getName());
        Assertions.notNull((String)"pageName", (Object)pageName);
        PortalPage portalPage = this.portalPageStore.getPortalPageByOwnerAndName(owner, pageName);
        return this.setRelatedState(portalPage);
    }

    public PortalPage getSystemDefaultPortalPage() {
        PortalPage systemDefaultPortalPage = this.portalPageStore.getSystemDefaultPortalPage();
        return this.setRelatedState(systemDefaultPortalPage);
    }

    public PortalPage getPortalPage(ApplicationUser user, Long id) {
        Assertions.notNull((String)"id", (Object)id);
        PortalPage portalPage = this.portalPageStore.getPortalPage(id);
        if (portalPage == null) {
            return null;
        }
        if (!this.hasPermissionToUse(user, portalPage)) {
            return null;
        }
        return this.setRelatedState(portalPage);
    }

    public PortalPage getPortalPageById(Long portalPageId) {
        Assertions.notNull((String)"portalPageId", (Object)portalPageId);
        PortalPage portalPage = this.portalPageStore.getPortalPage(portalPageId);
        return this.setRelatedState(portalPage);
    }

    public PortalPage create(PortalPage portalPage) {
        PortalPage createdPortalPage = this.createNoEvent(portalPage);
        this.eventPublisher.publish((Object)new DashboardCreated(createdPortalPage, this.authenticationContext.getUser()));
        this.eventPublisher.publish((Object)new SharedEntityCreatedEvent((SharedEntity)createdPortalPage));
        return createdPortalPage;
    }

    protected PortalPage createNoEvent(PortalPage portalPage) {
        this.assertCreate(portalPage);
        PortalPage createdPortalPage = PortalPage.portalPage((PortalPage)this.portalPageStore.create(portalPage)).permissions(portalPage.getPermissions()).build();
        this.shareManager.updateSharePermissions((SharedEntity)createdPortalPage);
        this.indexer.index((SharedEntity)createdPortalPage).await();
        return createdPortalPage;
    }

    public PortalPage createBasedOnClone(ApplicationUser pageOwner, PortalPage portalPage, PortalPage clonePortalPage) {
        this.assertCreate(portalPage);
        Assertions.notNull((String)"clonePortalPage", (Object)clonePortalPage);
        PortalPage portalPageToCreate = PortalPage.portalPage((PortalPage)portalPage).layout(clonePortalPage.getLayout()).build();
        PortalPage newPortalPage = this.createNoEvent(portalPageToCreate);
        this.clonePortletsFromOnePageToAnother(pageOwner, clonePortalPage, newPortalPage);
        this.eventPublisher.publish((Object)new DashboardCreated(newPortalPage, this.authenticationContext.getUser()));
        this.eventPublisher.publish((Object)new SharedEntityCreatedEvent((SharedEntity)newPortalPage));
        return newPortalPage;
    }

    public PortalPage update(PortalPage portalPage) {
        this.assertCreate(portalPage);
        Assertions.notNull((String)"portalPage.id", (Object)portalPage.getId());
        PortalPage oldPortalPage = this.getPortalPageWithSharePermissions(portalPage.getId());
        PortalPage newPortalPage = PortalPage.portalPage((PortalPage)this.portalPageStore.update(portalPage)).permissions(portalPage.getPermissions()).build();
        this.shareManager.updateSharePermissions((SharedEntity)newPortalPage);
        this.indexer.index((SharedEntity)newPortalPage).await();
        this.eventPublisher.publish((Object)new DashboardUpdated(portalPage, newPortalPage, this.authenticationContext.getLoggedInUser()));
        this.eventPublisher.publish((Object)new SharedEntityUpdatedEvent((SharedEntity)oldPortalPage, (SharedEntity)newPortalPage));
        this.eventPublisher.publish((Object)new SharedEntityUpdatedMetricsEvent(SharedEntityUpdatedMetricsEvent.SharedEntityEventType.DASHBOARD, (SharedEntity)oldPortalPage, (SharedEntity)newPortalPage, this.authenticationContext.getLoggedInUser()));
        return newPortalPage;
    }

    public void delete(Long portalPageId) {
        Assertions.notNull((String)"portalPageId", (Object)portalPageId);
        List portlectConfigurations = this.portletConfigurationManager.getByPortalPage(portalPageId);
        for (PortletConfiguration portletConfiguration : portlectConfigurations) {
            this.portletConfigurationManager.delete(portletConfiguration);
        }
        SharedEntity.Identifier identifier = new SharedEntity.Identifier(portalPageId, PortalPage.ENTITY_TYPE, (ApplicationUser)null);
        PortalPage portalPageToBeDeleted = this.getPortalPageWithSharePermissions(portalPageId);
        this.portalPageStore.delete(portalPageId);
        this.shareManager.deletePermissions((SharedEntity)identifier);
        this.indexer.deIndex((SharedEntity)identifier).await();
        this.eventPublisher.publish((Object)new DashboardDeleted((SharedEntity)identifier, this.authenticationContext.getUser()));
        this.eventPublisher.publish((Object)new SharedEntityDeletedEvent((SharedEntity)portalPageToBeDeleted));
    }

    public void saveLegacyPortletConfiguration(PortletConfiguration portletConfiguration) {
        Assertions.notNull((String)"portletConfiguration", (Object)portletConfiguration);
        Long id = portletConfiguration.getId();
        PortletConfiguration pc = this.portletConfigurationManager.getByPortletId(id);
        if (pc == null) {
            throw new IllegalStateException("Trying to update portletConfiguration that doesn't exist with id '" + id + "'.");
        }
        this.portletConfigurationManager.store(portletConfiguration);
    }

    public SharedEntitySearchResult<PortalPage> search(SharedEntitySearchParameters searchParameters, ApplicationUser user, int pagePosition, int pageWidth) {
        Assertions.notNull((String)"searchParameters", (Object)searchParameters);
        Assertions.not((String)"pagePosition < 0", (pagePosition < 0 ? 1 : 0) != 0);
        Assertions.not((String)"pageWidth <= 0", (pageWidth <= 0 ? 1 : 0) != 0);
        return this.indexer.withSearcher(PortalPage.ENTITY_TYPE, searcher -> searcher.search(searchParameters, user, pagePosition, pageWidth));
    }

    public List<List<PortletConfiguration>> getPortletConfigurations(Long portalPageId) {
        ArrayList<List<PortletConfiguration>> columns = new ArrayList<List<PortletConfiguration>>();
        List portletConfigurations = this.portletConfigurationManager.getByPortalPage(portalPageId);
        PortalPage portalPage = this.getPortalPageById(portalPageId);
        if (portalPage != null && !portletConfigurations.isEmpty()) {
            this.initColumns(portalPage.getLayout().getNumberOfColumns(), columns);
            for (PortletConfiguration portletConfiguration : portletConfigurations) {
                int column = portletConfiguration.getColumn();
                ((List)columns.get(column)).add(portletConfiguration);
            }
            for (int i = 0; i < columns.size(); ++i) {
                List column = (List)columns.get(i);
                Collections.sort(column);
                columns.set(i, Collections.unmodifiableList(column));
            }
        }
        return Collections.unmodifiableList(columns);
    }

    public boolean hasShareRights(@Nullable ApplicationUser user, @Nonnull PortalPage portalPage, @Nonnull ShareRight shareRight) {
        return this.shareManager.isSharedWith(user, (SharedEntity)portalPage, shareRight);
    }

    private PortalPage getPortalPageWithSharePermissions(Long id) {
        PortalPage portalPageWithoutSharePermissions = this.portalPageStore.getPortalPage(id);
        return PortalPage.portalPage((PortalPage)portalPageWithoutSharePermissions).permissions(this.shareManager.getSharePermissions((SharedEntity)portalPageWithoutSharePermissions)).build();
    }

    private void initColumns(int numberOfColumns, List<List<PortletConfiguration>> columns) {
        for (int i = 0; i < numberOfColumns; ++i) {
            columns.add(new ArrayList());
        }
    }

    private void clonePortletsFromOnePageToAnother(ApplicationUser owner, PortalPage clonePortalPage, PortalPage targetPortalPage) {
        Assertions.notNull((String)"owner", (Object)owner);
        Assertions.notNull((String)"clonePortalPage", (Object)clonePortalPage);
        Assertions.notNull((String)"targetPortalPage", (Object)targetPortalPage);
        GadgetPermissionManager gadgetPermissionManager = this.getGadgetPermissionManager();
        List pcsToClone = this.portletConfigurationManager.getByPortalPage(clonePortalPage.getId());
        for (PortletConfiguration pc : pcsToClone) {
            Option<PluginGadgetSpec> pluginGadgetSpec = gadgetPermissionManager.getPluginGadgetSpec((URI)pc.getOpenSocialSpecUri().getOrNull());
            boolean userHasPermissionToOpenSocialGadget = pluginGadgetSpec.isDefined() && Vote.ALLOW.equals((Object)gadgetPermissionManager.voteOn((PluginGadgetSpec)pluginGadgetSpec.get(), owner));
            boolean isDashboardItem = pc.getCompleteModuleKey().isDefined();
            if (!isDashboardItem && !userHasPermissionToOpenSocialGadget) continue;
            this.portletConfigurationManager.addDashBoardItem(targetPortalPage.getId(), pc.getColumn(), pc.getRow(), pc.getOpenSocialSpecUri(), pc.getColor(), pc.getUserPrefs(), pc.getCompleteModuleKey());
        }
    }

    GadgetPermissionManager getGadgetPermissionManager() {
        if (this.gadgetPermissionManager == null) {
            this.gadgetPermissionManager = (GadgetPermissionManager)ComponentAccessor.getComponentOfType(GadgetPermissionManager.class);
        }
        return this.gadgetPermissionManager;
    }

    private boolean isSharedWith(PortalPage entity, ApplicationUser user) {
        return this.shareManager.isSharedWith(user, (SharedEntity)entity);
    }

    private Collection<PortalPage> setRelatedState(Collection<PortalPage> portalPages) {
        ArrayList<PortalPage> ret = new ArrayList<PortalPage>(portalPages.size());
        for (PortalPage portalPage : portalPages) {
            ret.add(this.setRelatedState(portalPage));
        }
        return ret;
    }

    private PortalPage setRelatedState(PortalPage portalPage) {
        if (portalPage != null) {
            PortalPage.Builder builder = PortalPage.portalPage((PortalPage)portalPage);
            if (portalPage.isSystemDefaultPortalPage()) {
                builder.permissions(SharedEntity.SharePermissions.GLOBAL);
            } else {
                builder.permissions(this.shareManager.getSharePermissions((SharedEntity)portalPage));
            }
            return builder.build();
        }
        return null;
    }

    private void assertCreate(PortalPage portalPage) {
        Assertions.notNull((String)"portalPage", (Object)portalPage);
        if (!portalPage.isSystemDefaultPortalPage()) {
            Assertions.notNull((String)"portalPage.owner", (Object)portalPage.getOwner());
        }
        Assertions.notNull((String)"portalPage.pageName", (Object)portalPage.getName());
    }
}

