/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.cache.CacheManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.jira.bc.dataimport.DatabaseImportCompletedEvent;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectPropertiesManager;
import com.atlassian.jira.propertyset.CachingOfBizPropertySet;
import com.atlassian.jira.propertyset.SingleEntityCachingOfBizPropertyEntryStore;
import com.opensymphony.module.propertyset.PropertySet;
import javax.annotation.Nullable;

public class DefaultProjectPropertiesManager
implements ProjectPropertiesManager,
Startable {
    public static final String PROJECT_ENTITY_NAME = "Project";
    private final SingleEntityCachingOfBizPropertyEntryStore projectOfBizPropertyEntryStore;
    private final EventListenerRegistrar eventListenerRegistrar;

    public DefaultProjectPropertiesManager(CacheManager cacheManager, QueryDslAccessor queryDslAccessor, EventListenerRegistrar eventListenerRegistrar) {
        this.projectOfBizPropertyEntryStore = new SingleEntityCachingOfBizPropertyEntryStore(ProjectPropertiesManager.class.getSimpleName() + "." + PROJECT_ENTITY_NAME + ".cache", queryDslAccessor, cacheManager, false);
        this.eventListenerRegistrar = eventListenerRegistrar;
    }

    public void start() throws Exception {
        this.eventListenerRegistrar.register((Object)this);
    }

    public PropertySet getPropertySet(Project project) {
        return this.getPropertySet(project.getId());
    }

    public PropertySet getPropertySet(long projectId) {
        return new CachingOfBizPropertySet(this.projectOfBizPropertyEntryStore, PROJECT_ENTITY_NAME, projectId);
    }

    @EventListener
    public void onClearCache(@Nullable ClearCacheEvent event) {
        this.projectOfBizPropertyEntryStore.refreshAll();
    }

    @EventListener
    public void onDatabaseImportCompleted(DatabaseImportCompletedEvent event) {
        this.projectOfBizPropertyEntryStore.refreshAll();
    }
}

