/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.project.ProjectCreateHandler;
import com.atlassian.jira.project.ProjectCreateNotifier;
import com.atlassian.jira.project.ProjectCreateRegistrar;
import com.atlassian.jira.project.ProjectCreatedData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectCreateRegistrarImpl
implements ProjectCreateRegistrar,
ProjectCreateNotifier {
    private static final Logger log = LoggerFactory.getLogger(ProjectCreateRegistrarImpl.class);
    static final String APPLY_PROJECT_TEMPLATE_HANDLER_ID = "com.atlassian.jira.project-templates-plugin:apply-project-template-handler";
    protected final Map<String, ProjectCreateHandler> handlers = new ConcurrentHashMap<String, ProjectCreateHandler>();

    @Override
    public boolean notifyAllHandlers(ProjectCreatedData projectCreatedData) {
        ArrayList notifiedHandlers = Lists.newArrayList();
        boolean handlersWereSuccessful = true;
        for (ProjectCreateHandler handler2 : this.handlersWithProjectTemplateHandlerFirst()) {
            try {
                notifiedHandlers.add(handler2);
                handler2.onProjectCreated(projectCreatedData);
            }
            catch (CreateException | RuntimeException exception) {
                log.error("The handler with id " + handler2.getHandlerId() + " threw an exception while handling a notification about a project being created", exception);
                handlersWereSuccessful = false;
                break;
            }
        }
        if (!handlersWereSuccessful) {
            notifiedHandlers.forEach(handler -> handler.onProjectCreationRolledBack(projectCreatedData));
        }
        return handlersWereSuccessful;
    }

    private List<ProjectCreateHandler> handlersWithProjectTemplateHandlerFirst() {
        return (List)this.getHandlers().stream().sorted((handler1, handler2) -> handler1.getHandlerId().equals(APPLY_PROJECT_TEMPLATE_HANDLER_ID) ? -1 : 0).collect(CollectorsUtil.toImmutableList());
    }

    @VisibleForTesting
    protected Collection<ProjectCreateHandler> getHandlers() {
        return this.handlers.values();
    }

    public void register(ProjectCreateHandler handlerToAdd) {
        this.handlers.put(handlerToAdd.getHandlerId(), handlerToAdd);
    }

    public void unregister(ProjectCreateHandler handlerToRemove) {
        this.handlers.remove(handlerToRemove.getHandlerId());
    }
}

