/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.archiving;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.dataimport.DataImportFinishedEvent;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.event.ProjectDeletedEvent;
import com.atlassian.jira.event.project.ProjectArchivedEvent;
import com.atlassian.jira.event.project.ProjectRestoredEvent;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.issue.managers.IssueArchiveHelper;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.archiving.ArchivedProjectAnalyticEvent;
import com.atlassian.jira.project.archiving.ArchivedProjectManager;
import com.atlassian.jira.project.archiving.ArchivedProjectService;
import com.atlassian.jira.project.archiving.ArchivedStatistics;
import com.atlassian.jira.project.archiving.ArchivingLicenseCheck;
import com.atlassian.jira.project.archiving.RestoredProjectAnalyticEvent;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultArchivedProjectService
implements ArchivedProjectService {
    private static final Logger log = LoggerFactory.getLogger(DefaultArchivedProjectService.class);
    private final ArchivedProjectManager archivedProjectManager;
    private final IssueIndexingService issueIndexingService;
    private final I18nHelper.BeanFactory i18nFactory;
    private final EventPublisher eventPublisher;
    private final IssueManager issueManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final ArchivedStatistics archivedStatistics;
    private final ProjectService projectService;
    private final ArchivingLicenseCheck archivingLicenseCheck;
    private final IssueArchiveHelper issueArchiveHelper;

    public DefaultArchivedProjectService(ArchivedProjectManager archivedProjectManager, IssueIndexingService issueIndexingService, I18nHelper.BeanFactory i18nFactory, EventPublisher eventPublisher, IssueManager issueManager, JiraAuthenticationContext jiraAuthenticationContext, GlobalPermissionManager globalPermissionManager, ArchivedStatistics archivedStatistics, ProjectService projectService, ArchivingLicenseCheck archivingLicenseCheck, IssueArchiveHelper issueArchiveHelper) {
        this.archivedProjectManager = archivedProjectManager;
        this.issueIndexingService = issueIndexingService;
        this.i18nFactory = i18nFactory;
        this.eventPublisher = eventPublisher;
        this.issueManager = issueManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.globalPermissionManager = globalPermissionManager;
        this.archivedStatistics = archivedStatistics;
        this.projectService = projectService;
        this.archivingLicenseCheck = archivingLicenseCheck;
        this.issueArchiveHelper = issueArchiveHelper;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void onDataImport(DataImportFinishedEvent event) {
        this.archivedStatistics.invalidate();
    }

    @EventListener
    public void onProjectDeleted(ProjectDeletedEvent event) {
        if (event.getProject().isArchived()) {
            this.archivedStatistics.invalidate();
        }
    }

    public ArchivedProjectService.ArchivingResult archiveProject(ArchivedProjectService.ValidationResult validation) {
        Project project = validation.getProject();
        if (!this.archivingLicenseCheck.isLicensedForProjectArchiving()) {
            return this.createErrorResult(project, "admin.errors.archivedproject.error.feature.not.active", ErrorCollection.Reason.FORBIDDEN);
        }
        try {
            this.archivedProjectManager.markProjectAsArchived(project, this.jiraAuthenticationContext.getLoggedInUser());
        }
        catch (IllegalStateException e) {
            log.error("Error while marking project as archived", (Throwable)e);
            return this.createErrorResult(project, "admin.errors.archivedproject.error.archiving.archived", ErrorCollection.Reason.VALIDATION_FAILED);
        }
        this.archivedStatistics.invalidate();
        Instant startTime = Instant.now();
        this.issueArchiveHelper.archiveIssuesInProject(project);
        this.eventPublisher.publish((Object)new ArchivedProjectAnalyticEvent(project.getId(), this.issueManager.getIssueCountForProject(project.getId()), Duration.between(startTime, Instant.now()).toMillis()));
        this.eventPublisher.publish((Object)new ProjectArchivedEvent(project, this.jiraAuthenticationContext.getLoggedInUser()));
        return new ArchivedProjectService.ArchivingResult((ErrorCollection)new SimpleErrorCollection(), project);
    }

    public ArchivedProjectService.ValidationResult validateArchiveProject(ApplicationUser user, String projectKey) {
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            return new ArchivedProjectService.ValidationResult(ErrorCollections.create((String)this.i18nFactory.getInstance(this.jiraAuthenticationContext.getLoggedInUser()).getText("admin.errors.archivedproject.error.no.admin.permission"), (ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN), projectKey);
        }
        ProjectService.GetProjectResult getProjectResult = this.projectService.getProjectByKeyForAction(user, projectKey, ProjectAction.ARCHIVE_PROJECT);
        if (!getProjectResult.isValid() || getProjectResult.getProject() == null) {
            return new ArchivedProjectService.ValidationResult(ErrorCollections.copyOf((ErrorCollection)getProjectResult.getErrorCollection()), projectKey);
        }
        return new ArchivedProjectService.ValidationResult(ErrorCollections.empty(), getProjectResult.getProject());
    }

    public ArchivedProjectService.ArchivingResult restoreProject(ArchivedProjectService.ValidationResult validation) {
        Project project = validation.getProject();
        if (!this.archivingLicenseCheck.isLicensedForProjectArchiving()) {
            return this.createErrorResult(project, "admin.errors.archivedproject.error.not.active", ErrorCollection.Reason.FORBIDDEN);
        }
        try {
            this.archivedProjectManager.markProjectAsActive(project);
        }
        catch (IllegalStateException e) {
            log.error("Error while marking project as active", (Throwable)e);
            return this.createErrorResult(project, "admin.errors.archivedproject.error.restoring.restored", ErrorCollection.Reason.VALIDATION_FAILED);
        }
        this.issueArchiveHelper.restoreIssuesInProject(project);
        this.archivedStatistics.invalidate();
        this.eventPublisher.publish((Object)new RestoredProjectAnalyticEvent(project.getId(), this.issueManager.getIssueCountForProject(project.getId())));
        this.eventPublisher.publish((Object)new ProjectRestoredEvent(project, this.jiraAuthenticationContext.getLoggedInUser()));
        return new ArchivedProjectService.ArchivingResult((ErrorCollection)new SimpleErrorCollection(), project);
    }

    public ArchivedProjectService.ValidationResult validateRestoreProject(ApplicationUser user, String projectKey) {
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            return new ArchivedProjectService.ValidationResult(ErrorCollections.create((String)this.i18nFactory.getInstance(this.jiraAuthenticationContext.getLoggedInUser()).getText("admin.errors.archivedproject.error.no.admin.permission"), (ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN), projectKey);
        }
        ProjectService.GetProjectResult getProjectResult = this.projectService.getProjectByKeyForAction(user, projectKey, ProjectAction.ARCHIVE_PROJECT);
        if (!getProjectResult.isValid() || getProjectResult.getProject() == null) {
            return new ArchivedProjectService.ValidationResult(ErrorCollections.copyOf((ErrorCollection)getProjectResult.getErrorCollection()), projectKey);
        }
        return new ArchivedProjectService.ValidationResult(ErrorCollections.empty(), getProjectResult.getProject());
    }

    private ArchivedProjectService.ArchivingResult createErrorResult(Project project, String errorKey, ErrorCollection.Reason failedReason) {
        SimpleErrorCollection simpleErrorCollection = new SimpleErrorCollection();
        simpleErrorCollection.addErrorMessage(this.i18nFactory.getInstance(this.jiraAuthenticationContext.getLoggedInUser()).getText(errorKey), failedReason);
        return new ArchivedProjectService.ArchivingResult((ErrorCollection)simpleErrorCollection, project);
    }
}

