/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.template.hook;

import com.atlassian.jira.project.template.hook.IssueTypeTemplate;
import com.atlassian.plugin.Plugin;
import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.URL;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IssueTypeTemplateImpl
implements IssueTypeTemplate {
    private final String key;
    private final String name;
    private final String description;
    private final String iconPath;
    private final URL iconUrl;
    private final Optional<String> workflow;
    private final boolean isSubtask;
    private final Optional<String> screenScheme;
    private final Optional<String> avatar;

    public IssueTypeTemplateImpl(@JsonProperty(value="key") String key, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="icon") String iconPath, @JsonProperty(value="workflow") String workflow, @JsonProperty(value="sub-task") Boolean isSubtask, @JsonProperty(value="screen-scheme") String screenScheme, @JsonProperty(value="avatar") String avatar, @JacksonInject(value="plugin") Plugin plugin) {
        this.key = ((String)Preconditions.checkNotNull((Object)key)).toUpperCase();
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.description = Strings.nullToEmpty((String)description);
        this.workflow = workflow == null ? Optional.empty() : Optional.of(workflow.toUpperCase());
        this.isSubtask = Boolean.TRUE.equals(isSubtask);
        this.iconPath = iconPath;
        this.iconUrl = this.getIconUrl(plugin);
        this.avatar = Optional.ofNullable(avatar);
        this.screenScheme = screenScheme == null ? Optional.empty() : Optional.of(screenScheme.toUpperCase());
    }

    public String key() {
        return this.key;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String iconPath() {
        return this.iconPath;
    }

    public URL iconUrl() {
        return this.iconUrl;
    }

    public Optional<String> workflow() {
        return this.workflow;
    }

    public String style() {
        if (this.isSubtask()) {
            return "jira_subtask";
        }
        return "";
    }

    public boolean isSubtask() {
        return this.isSubtask;
    }

    public Optional<String> screenScheme() {
        return this.screenScheme;
    }

    public Optional<String> avatar() {
        return this.avatar;
    }

    private URL getIconUrl(Plugin plugin) {
        if (this.iconPath == null) {
            return null;
        }
        URL url = plugin.getResource(this.iconPath);
        if (url == null) {
            throw new IllegalArgumentException("Icon for issue type '" + this.key + "'not found on path specified: " + this.iconPath);
        }
        return url;
    }
}

