/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.type.warning;

import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeManager;
import com.atlassian.jira.project.type.warning.InaccessibleProjectTypeDialogContent;
import com.atlassian.jira.project.type.warning.InaccessibleProjectTypeDialogContentProvider;
import com.atlassian.jira.project.type.warning.InaccessibleProjectTypeDialogDataProvider;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;

public class InaccessibleProjectTypeDialogDataProviderImpl
implements InaccessibleProjectTypeDialogDataProvider {
    static final String DIALOGS_KEY = "project.type.warning.dialogs.data";
    private static final ObjectMapper OBJECT_MAPPER;
    private final GlobalPermissionManager globalPermissionManager;
    private final PermissionManager permissionManager;
    private final ProjectTypeManager projectTypeManager;
    private final InaccessibleProjectTypeDialogContentProvider dialogContentProvider;

    public InaccessibleProjectTypeDialogDataProviderImpl(GlobalPermissionManager globalPermissionManager, PermissionManager permissionManager, ProjectTypeManager projectTypeManager, InaccessibleProjectTypeDialogContentProvider dialogContentProvider) {
        this.globalPermissionManager = globalPermissionManager;
        this.permissionManager = permissionManager;
        this.projectTypeManager = projectTypeManager;
        this.dialogContentProvider = dialogContentProvider;
    }

    public boolean shouldDisplayInaccessibleWarning(ApplicationUser user, Project project) {
        return this.isAdmin(user, project) && this.isProjectTypeUninstalledOrUnlicensed(project.getProjectTypeKey());
    }

    public void provideData(WebResourceAssembler assembler, ApplicationUser user, Project project) {
        assembler.data().requireData(DIALOGS_KEY, this.getJsonable(this.dialogContentProvider.getContent(user, project)));
    }

    @VisibleForTesting
    protected Jsonable getJsonable(InaccessibleProjectTypeDialogContent content) {
        return writer -> OBJECT_MAPPER.writeValue(writer, (Object)content);
    }

    private boolean isAdmin(ApplicationUser user, Project project) {
        return this.isGlobalAdmin(user) || this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, user);
    }

    private boolean isGlobalAdmin(ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    private boolean isProjectTypeUninstalledOrUnlicensed(ProjectTypeKey projectTypeKey) {
        return this.projectTypeManager.isProjectTypeUninstalled(projectTypeKey) || this.projectTypeManager.isProjectTypeInstalledButInaccessible(projectTypeKey);
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        OBJECT_MAPPER = mapper;
    }
}

