/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.login.LoginManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.seraph.auth.RoleMapper;
import com.atlassian.seraph.config.SecurityConfig;
import java.security.Principal;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;

public class JiraRoleMapper
implements RoleMapper {
    public boolean hasRole(@Nullable Principal user, HttpServletRequest httpServletRequest, String role) {
        return this.getLoginManager().authoriseForRole(this.toApplicationUser(user), httpServletRequest, role);
    }

    public boolean canLogin(@Nullable Principal user, HttpServletRequest httpServletRequest) {
        if (user != null) {
            ApplicationUser applicationUser = this.toApplicationUser(user);
            return applicationUser.isActive() && this.getLoginManager().authoriseForLogin(applicationUser, httpServletRequest);
        }
        return false;
    }

    protected ApplicationUser toApplicationUser(Principal user) {
        return user != null ? this.getUserManager().getUserByName(user.getName()) : null;
    }

    public void init(Map map, SecurityConfig securityConfig) {
    }

    LoginManager getLoginManager() {
        return (LoginManager)ComponentAccessor.getComponentOfType(LoginManager.class);
    }

    UserManager getUserManager() {
        return ComponentAccessor.getUserManager();
    }
}

