/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.security.filter.DeserializationFilterConfigurator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesBasedDeserializationFilterConfigurator
implements DeserializationFilterConfigurator {
    private static final String BLOCKLIST_PROPERTIES_FILE = "deserialization-blocklist.properties";
    private static final Logger log = LoggerFactory.getLogger(PropertiesBasedDeserializationFilterConfigurator.class);
    private final StringWriter exceptionStringWriter = new StringWriter();
    private final PrintWriter exceptionPrintWriter = new PrintWriter(this.exceptionStringWriter);

    @Override
    public void configureSerialFilter() {
        try {
            this.setJdk8SerialFilter();
            if (this.getCurrentSerialFilterClass() == null) {
                this.setJdk11SerialFilter();
            }
            if (this.getCurrentSerialFilterClass() == null) {
                log.error(this.exceptionStringWriter.toString());
                String url = "https://confluence.atlassian.com/adminjiraserver/live-monitoring-using-the-jmx-interface-939707304.html";
                throw new RuntimeException("BlocklistDeserializationFilter has not been set up, please check: " + url);
            }
            log.info("BlocklistDeserializationFilter successfully registered");
        }
        catch (IllegalStateException e) {
            log.error("Could not to create serial filter because it is already set. The current filter is based on this class: {}", this.getCurrentSerialFilterClass());
            throw new IllegalStateException("Serial filter can only be set once. Error: " + e.getMessage(), e);
        }
        finally {
            this.exceptionPrintWriter.close();
            try {
                this.exceptionStringWriter.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<String> getBlockedClassesFromFile() {
        try (InputStream blocklistPropertyFile = ClassLoaderUtils.getResourceAsStream((String)BLOCKLIST_PROPERTIES_FILE, this.getClass());){
            Set<String> set = this.readBlockedClasses(blocklistPropertyFile);
            return set;
        }
        catch (IOException e) {
            log.error("Could not load default properties from '{}'. Deserialization filtering is disabled. {}", (Object)BLOCKLIST_PROPERTIES_FILE, (Object)e);
            return Collections.emptySet();
        }
    }

    private Set<String> readBlockedClasses(InputStream blocklistPropertyFile) {
        return new BufferedReader(new InputStreamReader(blocklistPropertyFile)).lines().filter(listedClass -> StringUtils.isNotBlank((CharSequence)listedClass) && !listedClass.startsWith("#")).collect(Collectors.toSet());
    }

    private Class<?> getCurrentSerialFilterClass() {
        Class<?> objectInputStreamConfig = null;
        try {
            objectInputStreamConfig = Class.forName("sun.misc.ObjectInputFilter$Config");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (objectInputStreamConfig == null) {
            try {
                objectInputStreamConfig = Class.forName("java.io.ObjectInputFilter$Config");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            assert (objectInputStreamConfig != null);
            Object currentSerialFilter = objectInputStreamConfig.getMethod("getSerialFilter", new Class[0]).invoke(null, new Object[0]);
            return currentSerialFilter == null ? null : currentSerialFilter.getClass();
        }
        catch (AssertionError | ReflectiveOperationException e) {
            ((Throwable)e).printStackTrace(this.exceptionPrintWriter);
            this.exceptionPrintWriter.flush();
            return null;
        }
    }

    private void setJdk8SerialFilter() throws IllegalStateException {
        try {
            Class<?> jdk8ObjectInputStream = Class.forName("sun.misc.ObjectInputFilter");
            Class<?> jdk8ObjectInputStreamConfig = Class.forName("sun.misc.ObjectInputFilter$Config");
            Class<?> jdk8DeserializationFilter = Class.forName("com.atlassian.plugins.utils.jdk8.BlocklistDeserializationFilter");
            Object filterInstance = jdk8DeserializationFilter.getConstructor(Set.class).newInstance(this.getBlockedClassesFromFile());
            jdk8ObjectInputStreamConfig.getMethod("setSerialFilter", jdk8ObjectInputStream).invoke(null, filterInstance);
        }
        catch (NoClassDefFoundError | ReflectiveOperationException e) {
            e.printStackTrace(this.exceptionPrintWriter);
            this.exceptionPrintWriter.flush();
        }
    }

    private void setJdk11SerialFilter() throws IllegalStateException {
        try {
            Class<?> jdk11ObjectInputStream = Class.forName("java.io.ObjectInputFilter");
            Class<?> jdk11ObjectInputStreamConfig = Class.forName("java.io.ObjectInputFilter$Config");
            Class<?> jdk11DeserializationFilter = Class.forName("com.atlassian.plugins.utils.BlocklistDeserializationFilter");
            Object filterInstance = jdk11DeserializationFilter.getConstructor(Set.class).newInstance(this.getBlockedClassesFromFile());
            jdk11ObjectInputStreamConfig.getMethod("setSerialFilter", jdk11ObjectInputStream).invoke(null, filterInstance);
        }
        catch (NoClassDefFoundError | ReflectiveOperationException e) {
            e.printStackTrace(this.exceptionPrintWriter);
            this.exceptionPrintWriter.flush();
        }
    }
}

