/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.PropertiesUtil;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.permission.WorkflowPermissionFactory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.security.PermissionsCache;
import com.atlassian.jira.security.ProjectPermissionOverrideDescriptorCache;
import com.atlassian.jira.security.WorkflowBasedPermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.plugin.ProjectPermissionTypesManager;
import com.atlassian.jira.security.plugin.ScopesRequestCacheDelegate;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLocalCachingPermissionManager
extends WorkflowBasedPermissionManager {
    private static final Logger log = LoggerFactory.getLogger(ThreadLocalCachingPermissionManager.class);
    private static final int DEFAULT_CACHE_SIZE = 1000;
    private final ApplicationProperties applicationProperties;

    public ThreadLocalCachingPermissionManager(WorkflowPermissionFactory workflowPermissionFactory, PermissionContextFactory permissionContextFactory, ProjectPermissionTypesManager projectPermissionTypesManager, ProjectPermissionOverrideDescriptorCache projectPermissionOverrideDescriptorCache, ScopesRequestCacheDelegate scopesRequestCacheDelegate, ApplicationProperties applicationProperties) {
        super(workflowPermissionFactory, permissionContextFactory, projectPermissionTypesManager, projectPermissionOverrideDescriptorCache, scopesRequestCacheDelegate);
        this.applicationProperties = applicationProperties;
    }

    @Override
    public Collection<Project> getProjectObjects(ProjectPermissionKey permissionKey, ApplicationUser user) {
        if (ProjectPermissions.BROWSE_PROJECTS.equals((Object)permissionKey)) {
            PermissionsCache cache = this.getCache();
            return cache.computeProjectsWithBrowsePermissionIfAbsent(user, () -> super.getProjectObjects(permissionKey, user));
        }
        return super.getProjectObjects(permissionKey, user);
    }

    @Override
    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project, @Nullable ApplicationUser user) {
        if (ProjectPermissions.BROWSE_PROJECTS.equals((Object)permissionKey)) {
            PermissionsCache cache = this.getCache();
            return cache.computePermissionIfAbsent(user, project, () -> super.hasPermission(permissionKey, project, user));
        }
        return super.hasPermission(permissionKey, project, user);
    }

    @Override
    public void flushCache() {
        JiraAuthenticationContextImpl.getRequestCache().remove("jira.permissions.cache");
        log.debug("Flushed the PermissionsCache");
    }

    PermissionsCache getCache() {
        PermissionsCache cache = (PermissionsCache)JiraAuthenticationContextImpl.getRequestCache().get("jira.permissions.cache");
        if (cache == null) {
            if (log.isDebugEnabled()) {
                log.debug("Creating new PermissionsCache");
            }
            int cacheSize = PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)"jira.permission.cache.size", (int)1000);
            cache = new PermissionsCache(cacheSize);
            JiraAuthenticationContextImpl.getRequestCache().put("jira.permissions.cache", cache);
        }
        return cache;
    }
}

